/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.util;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.jbpm.kie.services.impl.form.provider.FreemakerFormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class VFSFormProvider
extends FreemakerFormProvider {
    private static final Logger logger = LoggerFactory.getLogger(VFSFormProvider.class);
    @Inject
    private FileService fileService;

    public String render(String name, ProcessAssetDesc process, Map<String, Object> renderContext) {
        if (process == null || process.getOriginalPath() == null) {
            return null;
        }
        ByteArrayInputStream template = null;
        Iterable<Path> availableForms = null;
        Path processPath = this.fileService.getPath(process.getOriginalPath());
        Path formsPath = this.fileService.getPath(processPath.getParent().toUri().toString() + "/forms/");
        try {
            if (this.fileService.exists(formsPath)) {
                availableForms = this.fileService.loadFilesByType(formsPath, "ftl");
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(process.getId())) continue;
                selectedForm = p;
            }
        }
        try {
            if (selectedForm == null) {
                Path defaultFormPath;
                String rootPath = processPath.getRoot().toUri().toString();
                if (!rootPath.endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                if (this.fileService.exists(defaultFormPath = this.fileService.getPath(rootPath + "globals/forms/DefaultProcess.ftl"))) {
                    template = new ByteArrayInputStream(this.fileService.loadFile(defaultFormPath));
                }
            } else {
                template = new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    public String render(String name, Task task, ProcessAssetDesc process, Map<String, Object> renderContext) {
        ByteArrayInputStream template = null;
        Path processPath = null;
        Iterable<Path> availableForms = null;
        try {
            Path formsPath;
            if (process != null && process.getOriginalPath() != null && this.fileService.exists(formsPath = this.fileService.getPath((processPath = this.fileService.getPath(process.getOriginalPath())).getParent().toUri().toString() + "/forms/"))) {
                availableForms = this.fileService.loadFilesByType(formsPath, "ftl");
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(((I18NText)task.getNames().get(0)).getText())) continue;
                selectedForm = p;
            }
        }
        try {
            if (selectedForm == null) {
                Path defaultFormPath;
                String rootPath = "";
                if (processPath != null && !(rootPath = processPath.getRoot().toUri().toString()).endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                if (!rootPath.equals("") && this.fileService.exists(defaultFormPath = this.fileService.getPath(rootPath + "globals/forms/DefaultTask.ftl"))) {
                    template = new ByteArrayInputStream(this.fileService.loadFile(defaultFormPath));
                }
            } else {
                template = new ByteArrayInputStream(this.fileService.loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    public int getPriority() {
        return 1;
    }
}

