/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.command.runtime.process.SetProcessInstanceVariablesCommand;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.service.KieSessionEntryPoint;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@Service
@ApplicationScoped
public class KieSessionEntryPointImpl
implements KieSessionEntryPoint {
    @Inject
    private DeploymentService deploymentService;
    @Inject
    private RuntimeDataService dataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startProcess(String domainName, String processId) {
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(domainName).getRuntimeManager();
        RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance pi = null;
        try {
            pi = ksession.startProcess(processId);
        }
        catch (Exception e) {
            ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            runtimesByDomain.disposeRuntimeEngine(engine);
        }
        return pi.getId();
    }

    public long startProcess(String domainName, String processId, Map<String, String> params) {
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(domainName).getRuntimeManager();
        RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance pi = null;
        try {
            pi = ksession.startProcess(processId, new HashMap<String, String>(params));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            runtimesByDomain.disposeRuntimeEngine(engine);
        }
        return pi.getId();
    }

    public void abortProcessInstance(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.abortProcessInstance(processInstanceId);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            runtimesByDomain.disposeRuntimeEngine(engine);
        }
    }

    public void abortProcessInstances(List<Long> processInstanceIds) {
        for (long processInstanceId : processInstanceIds) {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
            KieSession ksession = engine.getKieSession();
            try {
                ksession.abortProcessInstance(processInstanceId);
            }
            catch (Exception e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
            finally {
                runtimesByDomain.disposeRuntimeEngine(engine);
            }
        }
    }

    public void suspendProcessInstance(long processInstanceId) {
    }

    public void signalProcessInstance(long processInstanceId, String signalName, Object event) {
        if (processInstanceId != -1L) {
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
            KieSession ksession = engine.getKieSession();
            try {
                ksession.signalEvent(signalName, event, processInstanceId);
            }
            catch (Exception e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
            finally {
                runtimesByDomain.disposeRuntimeEngine(engine);
            }
        }
    }

    public void signalProcessInstances(List<Long> processInstanceIds, String signalName, Object event) {
        for (Long processInstanceId : processInstanceIds) {
            if (processInstanceId == -1L) continue;
            ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId.longValue());
            RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
            RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
            KieSession ksession = engine.getKieSession();
            try {
                ksession.signalEvent(signalName, event, processInstanceId.longValue());
            }
            catch (Exception e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
            finally {
                runtimesByDomain.disposeRuntimeEngine(engine);
            }
        }
    }

    public Collection<String> getAvailableSignals(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
            ArrayList<String> activeSignals = new ArrayList<String>();
            if (processInstance != null) {
                ((ProcessInstanceImpl)processInstance).setProcess(ksession.getKieBase().getProcess(processInstance.getProcessId()));
                Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
                activeSignals.addAll(ProcessInstanceHelper.collectActiveSignals((Collection)activeNodes));
            }
            ArrayList<String> arrayList = activeSignals;
            return arrayList;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            runtimesByDomain.disposeRuntimeEngine(engine);
        }
    }

    public void setProcessVariable(long processInstanceId, String variableId, Object value) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        RuntimeManager runtimesByDomain = this.deploymentService.getDeployedUnit(piDesc.getDeploymentId()).getRuntimeManager();
        RuntimeEngine engine = runtimesByDomain.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = engine.getKieSession();
        try {
            ksession.execute((Command)new SetProcessInstanceVariablesCommand(processInstanceId, Collections.singletonMap(variableId, value)));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            runtimesByDomain.disposeRuntimeEngine(engine);
        }
    }
}

