/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.util;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.jbpm.console.ng.bd.api.VFSDeploymentUnit;
import org.jbpm.console.ng.bd.api.Vfs;
import org.jbpm.runtime.manager.api.WorkItemHandlerProducer;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentService;
import org.uberfire.java.nio.file.Path;

public class VfsMVELWorkItemHandlerProducer
implements WorkItemHandlerProducer {
    @Inject
    private Instance<FileService> fsIin;
    @Inject
    @Vfs
    private Instance<DeploymentService> deploymentService;
    private FileService fs;

    public void setFs(FileService fs) {
        this.fs = fs;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(String identifier, Map<String, Object> params) {
        HashMap<String, WorkItemHandler> handlers = new HashMap<String, WorkItemHandler>();
        try {
            DeployedUnit deployedUnit;
            if (this.deploymentService.get() == null) {
                return handlers;
            }
            if (this.fs != null) {
                this.fs = (FileService)this.fsIin.get();
            }
            if ((deployedUnit = ((DeploymentService)this.deploymentService.get()).getDeployedUnit(identifier)) == null) {
                return handlers;
            }
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)deployedUnit.getDeploymentUnit();
            Path assetFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            if (identifier == null || !this.fs.exists(assetFolder)) {
                return handlers;
            }
            params.put("fs", this.fs);
            Iterable<Path> widFiles = this.fs.loadFilesByType(assetFolder, "conf");
            for (Path widPath : widFiles) {
                String content = new String(this.fs.loadFile(widPath), "UTF-8");
                handlers.putAll((Map)MVELSafeHelper.getEvaluator().eval(content, params));
            }
        }
        catch (FileException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handlers;
    }
}

