/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.bd.model.RuntimeLogSummary;
import org.jbpm.console.ng.bd.service.DataServiceEntryPoint;
import org.jbpm.console.ng.ht.backend.server.TaskDefHelper;
import org.jbpm.console.ng.ht.model.TaskDefSummary;
import org.jbpm.console.ng.ht.model.TaskEventSummary;
import org.jbpm.console.ng.ht.service.TaskServiceEntryPoint;
import org.jbpm.console.ng.pr.backend.server.NodeInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessHelper;
import org.jbpm.console.ng.pr.backend.server.ProcessInstanceHelper;
import org.jbpm.console.ng.pr.backend.server.VariableHelper;
import org.jbpm.console.ng.pr.model.NodeInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessInstanceSummary;
import org.jbpm.console.ng.pr.model.ProcessSummary;
import org.jbpm.console.ng.pr.model.ProcessVariableSummary;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.QueryContextImpl;
import org.kie.internal.query.QueryContext;
import org.ocpsoft.prettytime.PrettyTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class DataServiceEntryPointImpl
implements DataServiceEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(DataServiceEntryPointImpl.class);
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    private DefinitionService bpmn2Service;

    public Map<String, String> getServiceTasks(String deploymentId, String processId) {
        return this.bpmn2Service.getServiceTasks(deploymentId, processId);
    }

    public Collection<ProcessInstanceSummary> getProcessInstances() {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstances((QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesByDeploymentId(deploymentId, states, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<ProcessSummary> getProcessesByFilter(String filter) {
        return ProcessHelper.adaptCollection((Collection)this.dataService.getProcessesByFilter(filter, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public ProcessInstanceSummary getProcessInstanceById(long processInstanceId) {
        return ProcessInstanceHelper.adapt((ProcessInstanceDesc)this.dataService.getProcessInstanceById(processInstanceId));
    }

    public ProcessSummary getProcessById(String deploymentId, String processId) {
        return ProcessHelper.adapt((ProcessDefinition)this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId));
    }

    public Collection<ProcessInstanceSummary> getProcessInstancesByProcessDefinition(String processDefId) {
        return ProcessInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstancesByProcessDefinition(processDefId, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistoryByType(piDesc.getDeploymentId(), processInstanceId, RuntimeDataService.EntryType.START, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceHistory(long processInstanceId, boolean completed) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        if (completed) {
            return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistoryByType(piDesc.getDeploymentId(), processInstanceId, RuntimeDataService.EntryType.END, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
        }
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistoryByType(piDesc.getDeploymentId(), processInstanceId, RuntimeDataService.EntryType.START, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceFullHistory(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceFullHistory(piDesc.getDeploymentId(), processInstanceId, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<NodeInstanceSummary> getProcessInstanceActiveNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistoryActive(piDesc.getDeploymentId(), processInstanceId, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<ProcessInstanceSummary> getProcessInstances(List<Integer> states, String filterText, String initiator) {
        Collection result = null;
        result = !filterText.equals("") ? this.dataService.getProcessInstancesByProcessName(states, filterText, initiator, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))) : this.dataService.getProcessInstances(states, initiator, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100)));
        return ProcessInstanceHelper.adaptCollection((Collection)result);
    }

    public Collection<NodeInstanceSummary> getProcessInstanceCompletedNodes(long processInstanceId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        return NodeInstanceHelper.adaptCollection((Collection)this.dataService.getProcessInstanceHistoryCompleted(piDesc.getDeploymentId(), processInstanceId, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<ProcessVariableSummary> getVariableHistory(long processInstanceId, String variableId) {
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariableHistory(processInstanceId, variableId, (QueryContext)new QueryContextImpl(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public Collection<String> getReusableSubProcesses(String deploymentId, String processId) {
        return this.bpmn2Service.getReusableSubProcesses(deploymentId, processId);
    }

    public Map<String, String> getRequiredInputData(String deploymentId, String processId) {
        return this.bpmn2Service.getProcessVariables(deploymentId, processId);
    }

    public Collection<TaskDefSummary> getAllTasksDef(String deploymentId, String processId) {
        return TaskDefHelper.adaptCollection((Collection)this.bpmn2Service.getTasksDefinitions(deploymentId, processId));
    }

    public Map<String, Collection<String>> getAssociatedEntities(String deploymentId, String processId) {
        return this.bpmn2Service.getAssociatedEntities(deploymentId, processId);
    }

    public ProcessSummary getProcessDesc(String deploymentId, String processId) {
        return ProcessHelper.adapt((ProcessDefinition)this.bpmn2Service.getProcessDefinition(deploymentId, processId));
    }

    public Collection<ProcessVariableSummary> getVariablesCurrentState(long processInstanceId, String processId) {
        ProcessInstanceDesc piDesc = this.dataService.getProcessInstanceById(processInstanceId);
        HashMap properties = new HashMap(this.bpmn2Service.getProcessVariables(piDesc.getDeploymentId(), processId));
        return VariableHelper.adaptCollection((Collection)this.dataService.getVariablesCurrentState(processInstanceId), properties, (long)processInstanceId);
    }

    public Map<String, String> getTaskInputMappings(String deploymentId, String processId, String taskName) {
        return this.bpmn2Service.getTaskInputMappings(deploymentId, processId, taskName);
    }

    public Map<String, String> getTaskOutputMappings(String deploymentId, String processId, String taskName) {
        return this.bpmn2Service.getTaskOutputMappings(deploymentId, processId, taskName);
    }

    public Collection<RuntimeLogSummary> getBusinessLogs(long processInstanceId) {
        ProcessInstanceSummary processInstanceData = this.getProcessInstanceById(processInstanceId);
        List processInstanceHistory = (List)this.getProcessInstanceHistory(processInstanceId);
        List allTaskEventsByProcessInstanceId = this.taskService.getAllTaskEventsByProcessInstanceId(processInstanceId, "");
        ArrayList<RuntimeLogSummary> logs = new ArrayList<RuntimeLogSummary>(processInstanceHistory.size() + allTaskEventsByProcessInstanceId.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yy HH:mm:ss");
        PrettyTime prettyDateFormatter = new PrettyTime();
        for (int i = processInstanceHistory.size() - 1; i >= 0; --i) {
            NodeInstanceSummary nis = (NodeInstanceSummary)processInstanceHistory.get(i);
            try {
                if (nis.getType().equals("HumanTaskNode")) {
                    logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), "Task '" + nis.getNodeName() + "' was created", "System"));
                    for (TaskEventSummary te : allTaskEventsByProcessInstanceId) {
                        if (te.getWorkItemId() == null || nis.getId() != te.getWorkItemId().longValue() || !te.getType().equals("CLAIMED") && !te.getType().equals("RELEASED") && !te.getType().equals("COMPLETED")) continue;
                        logs.add(new RuntimeLogSummary(nis.getId(), "- " + prettyDateFormatter.format(te.getLogTime()), "Task '" + nis.getNodeName() + "' was " + te.getType().toLowerCase() + " by user " + te.getUserId(), "Human"));
                    }
                    continue;
                }
                if (nis.getType().equals("StartNode")) {
                    logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), "Process '" + processInstanceData.getProcessName() + "' was created", "Human"));
                    continue;
                }
                if (!nis.getType().equals("EndNode")) continue;
                logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), "Process '" + processInstanceData.getProcessName() + "' was completed", "System"));
                continue;
            }
            catch (ParseException e) {
                logger.error("Can't create date from string using 'dd/MMM/yy HH:mm:ss' format!");
                throw new RuntimeException("Can't create date from string using 'dd/MMM/yy HH:mm:ss' format!", e);
            }
        }
        return logs;
    }

    public Collection<RuntimeLogSummary> getAllRuntimeLogs(long processInstanceId) {
        List processInstanceHistory = (List)this.getProcessInstanceHistory(processInstanceId);
        List allTaskEventsByProcessInstanceId = this.taskService.getAllTaskEventsByProcessInstanceId(processInstanceId, "");
        ArrayList<RuntimeLogSummary> logs = new ArrayList<RuntimeLogSummary>(processInstanceHistory.size() + allTaskEventsByProcessInstanceId.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yy HH:mm:ss");
        PrettyTime prettyDateFormatter = new PrettyTime();
        for (int i = processInstanceHistory.size() - 1; i >= 0; --i) {
            NodeInstanceSummary nis = (NodeInstanceSummary)processInstanceHistory.get(i);
            try {
                if (nis.getType().equals("HumanTaskNode")) {
                    logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), nis.getNodeName() + "(" + nis.getType() + ")", "System"));
                    for (TaskEventSummary te : allTaskEventsByProcessInstanceId) {
                        if (te.getWorkItemId() == null || nis.getId() != te.getWorkItemId().longValue()) continue;
                        if (te.getType().equals("ADDED")) {
                            logs.add(new RuntimeLogSummary(nis.getId(), "- " + prettyDateFormatter.format(te.getLogTime()), te.getUserId() + "->" + te.getType(), "System"));
                            continue;
                        }
                        logs.add(new RuntimeLogSummary(nis.getId(), "- " + prettyDateFormatter.format(te.getLogTime()), te.getUserId() + "->" + te.getType(), "Human"));
                    }
                    continue;
                }
                if (nis.getType().equals("StartNode")) {
                    logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), nis.getNodeName() + "(" + nis.getType() + ")", "Human"));
                    continue;
                }
                logs.add(new RuntimeLogSummary(nis.getId(), prettyDateFormatter.format(dateFormat.parse(nis.getTimestamp())), nis.getNodeName() + "(" + nis.getType() + ")", "System"));
                continue;
            }
            catch (ParseException e) {
                logger.error("Can't create date from string using 'dd/MMM/yy HH:mm:ss' format!");
                throw new RuntimeException("Can't create date from string using 'dd/MMM/yy HH:mm:ss' format!", e);
            }
        }
        return logs;
    }
}

