/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.console.ng.bd.service.DeploymentUnitProvider;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Kjar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Kjar
public class UserDefinedDeploymentUnitProvider
implements DeploymentUnitProvider<DeploymentUnit> {
    private static final Logger logger = LoggerFactory.getLogger(UserDefinedDeploymentUnitProvider.class);

    public Set<DeploymentUnit> getDeploymentUnits() {
        File duFile;
        String deploymentUnitsFile;
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        String propertyDeployments = System.getProperty("jbpm.deployment.units");
        if (propertyDeployments != null) {
            String[] allGAVs;
            for (String gav : allGAVs = propertyDeployments.split(";")) {
                DeploymentUnit unit = this.buildDeploymentUnit(gav);
                if (unit == null) continue;
                deploymentUnits.add(unit);
            }
        }
        if ((deploymentUnitsFile = System.getProperty("jbpm.deployment.units.file")) != null && (duFile = new File(deploymentUnitsFile)).exists()) {
            try {
                Scanner duFileScanner = new Scanner(duFile);
                while (duFileScanner.hasNextLine()) {
                    String gav = duFileScanner.nextLine();
                    DeploymentUnit unit = this.buildDeploymentUnit(gav);
                    if (unit == null) continue;
                    deploymentUnits.add(unit);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return deploymentUnits;
    }

    protected DeploymentUnit buildDeploymentUnit(String gav) {
        String[] elems = gav.split(":");
        if (elems.length == 3) {
            return new KModuleDeploymentUnit(elems[0], elems[1], elems[2]);
        }
        if (elems.length == 5) {
            return new KModuleDeploymentUnit(elems[0], elems[1], elems[2], elems[3], elems[4]);
        }
        logger.warn("Unknown deployment unit {}", (Object)gav);
        return null;
    }
}

