/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.util;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.api.FileException;
import org.jbpm.console.ng.bd.api.FileService;
import org.jbpm.kie.services.impl.form.provider.FreemakerFormProvider;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class VFSFormProvider
extends FreemakerFormProvider {
    private static final Logger logger = LoggerFactory.getLogger(VFSFormProvider.class);
    @Inject
    private Instance<FileService> fileServiceIn;
    private FileService fs;

    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        if (process == null || process.getOriginalPath() == null) {
            return null;
        }
        ByteArrayInputStream template = null;
        Iterable<Path> availableForms = null;
        Path processPath = this.getFs().getPath(process.getOriginalPath());
        Path formsPath = this.getFs().getPath(processPath.getParent().toUri().toString() + "/forms/");
        try {
            if (this.getFs().exists(formsPath)) {
                availableForms = this.getFs().loadFilesByType(formsPath, "ftl");
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(process.getId())) continue;
                selectedForm = p;
            }
        }
        try {
            if (selectedForm == null) {
                String rootPath = processPath.getRoot().toUri().toString();
                if (!rootPath.endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                Path defaultFormPath = this.getFs().getPath(rootPath + "globals/forms/DefaultProcess.ftl");
                if (this.getFs().exists(defaultFormPath)) {
                    template = new ByteArrayInputStream(this.getFs().loadFile(defaultFormPath));
                }
            } else {
                template = new ByteArrayInputStream(this.getFs().loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        ByteArrayInputStream template = null;
        Path processPath = null;
        Iterable<Path> availableForms = null;
        try {
            if (process != null && process.getOriginalPath() != null) {
                processPath = this.getFs().getPath(process.getOriginalPath());
                Path formsPath = this.getFs().getPath(processPath.getParent().toUri().toString() + "/forms/");
                if (this.getFs().exists(formsPath)) {
                    availableForms = this.getFs().loadFilesByType(formsPath, "ftl");
                }
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        Path selectedForm = null;
        if (availableForms != null) {
            for (Path p : availableForms) {
                if (!p.getFileName().toString().contains(((I18NText)task.getNames().get(0)).getText())) continue;
                selectedForm = p;
            }
        }
        try {
            if (selectedForm == null) {
                String rootPath = "";
                if (processPath != null && !(rootPath = processPath.getRoot().toUri().toString()).endsWith(processPath.getFileSystem().getSeparator())) {
                    rootPath = rootPath + processPath.getFileSystem().getSeparator();
                }
                if (!rootPath.equals("")) {
                    Path defaultFormPath = this.getFs().getPath(rootPath + "globals/forms/DefaultTask.ftl");
                    if (this.getFs().exists(defaultFormPath)) {
                        template = new ByteArrayInputStream(this.getFs().loadFile(defaultFormPath));
                    }
                }
            } else {
                template = new ByteArrayInputStream(this.getFs().loadFile(selectedForm));
            }
        }
        catch (FileException ex) {
            logger.error("File exception", (Throwable)ex);
        }
        if (template == null) {
            return null;
        }
        return this.render(name, template, renderContext);
    }

    public int getPriority() {
        return 1;
    }

    public FileService getFs() {
        if (this.fs == null) {
            this.fs = (FileService)this.fileServiceIn.get();
        }
        return this.fs;
    }

    public void setFs(FileService fs) {
        this.fs = fs;
    }
}

