/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jbpm.console.ng.bd.api.VFSDeploymentUnit;
import org.jbpm.console.ng.bd.api.Vfs;
import org.jbpm.console.ng.bd.service.DeploymentUnitProvider;
import org.jbpm.services.api.model.DeploymentUnit;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Vfs
public class VFSRepoDeploymentUnitProvider
implements DeploymentUnitProvider<DeploymentUnit> {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;

    public Set<DeploymentUnit> getDeploymentUnits() {
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        Collection repositories = this.repositoryService.getRepositories();
        if (repositories == null || repositories.isEmpty()) {
            return deploymentUnits;
        }
        for (Repository repository : repositories) {
            DirectoryStream assetDirectories = this.ioService.newDirectoryStream(this.ioService.get(repository.getUri() + "/processes", new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) {
                    return Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]);
                }
            });
            for (Path p : assetDirectories) {
                String folder = p.toString();
                if (folder.startsWith("/")) {
                    folder = folder.substring(1);
                }
                deploymentUnits.add(new VFSDeploymentUnit(p.getFileName().toString(), repository.getAlias(), folder));
            }
        }
        return deploymentUnits;
    }
}

