/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.jbpm.console.ng.bd.backend.server.dd.DeploymentDescriptorManager;
import org.jbpm.console.ng.bd.service.AdministrationService;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class AdministrationServiceImpl
implements AdministrationService {
    private static final Logger logger = LoggerFactory.getLogger(AdministrationServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private KieProjectService projectService;

    @Override
    public void bootstrapRepository(String ou, String repoAlias, String repoUrl, String userName, String password) {
        Repository repository = null;
        try {
            repository = this.repositoryService.getRepository(repoAlias);
            if (repository == null) {
                RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
                if (repoUrl != null) {
                    configurations.setOrigin(repoUrl);
                }
                configurations.setUserName(userName);
                configurations.setPassword(password);
                repository = this.repositoryService.createRepository("git", repoAlias, configurations);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to create repository with alias {} due to {}", (Object)repoAlias, (Object)e.getMessage());
        }
        OrganizationalUnit demoOrganizationalUnit = this.organizationalUnitService.getOrganizationalUnit(ou);
        if (demoOrganizationalUnit == null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            if (repository != null) {
                repositories.add(repository);
            }
            this.organizationalUnitService.createOrganizationalUnit(ou, ou + "@jbpm.org", null, repositories);
        } else {
            Collection repositories = demoOrganizationalUnit.getRepositories();
            if (repositories != null) {
                boolean found = false;
                for (Repository repo : repositories) {
                    if (!repo.getAlias().equals(repository.getAlias())) continue;
                    found = true;
                }
                if (!found) {
                    this.organizationalUnitService.addRepository(demoOrganizationalUnit, repository);
                }
            }
        }
    }

    @Override
    public void bootstrapProject(String repoAlias, String group, String artifact, String version) {
        GAV gav = new GAV(group, artifact, version);
        try {
            Repository repository = this.repositoryService.getRepository(repoAlias);
            if (repository != null) {
                String projectLocation = repository.getUri() + this.ioService.getFileSystem(URI.create(repository.getUri())).getSeparator() + artifact;
                if (!this.ioService.exists(this.ioService.get(URI.create(projectLocation)))) {
                    this.projectService.newProject(repository.getBranchRoot(repository.getDefaultBranch()), new POM(gav), "/");
                }
            } else {
                logger.error("Repository " + repoAlias + " was not found, cannot add project");
            }
        }
        catch (Exception e) {
            logger.error("Unable to bootstrap project {} in repository {}", new Object[]{gav, repoAlias, e});
        }
    }

    public void createDeploymentDescriptor(@Observes NewProjectEvent newProjectEvent) {
        KieProject project = (KieProject)newProjectEvent.getProject();
        URI projectRootURI = URI.create(project.getRootPath().toURI());
        String repositoryAlias = projectRootURI.getHost();
        String metaInfPath = Paths.convert((org.uberfire.backend.vfs.Path)project.getKModuleXMLPath()).getParent().toUri().toString();
        String separator = Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()).getFileSystem().getSeparator();
        String deploymentDescriptorPath = metaInfPath + separator + "kie-deployment-descriptor.xml";
        Path ddVFSPath = this.ioService.get(URI.create(deploymentDescriptorPath));
        if (!this.ioService.exists(ddVFSPath)) {
            DeploymentDescriptor dd = new DeploymentDescriptorManager("org.jbpm.domain").getDefaultDescriptor();
            HashSet groups = new HashSet(project.getGroups());
            Repository repo = this.repositoryService.getRepository(repositoryAlias);
            if (repo != null) {
                groups.addAll(repo.getGroups());
            }
            dd.getBuilder().setRequiredRoles(new ArrayList(groups));
            String xmlDescriptor = dd.toXml();
            this.ioService.write(ddVFSPath, xmlDescriptor, new OpenOption[0]);
        }
    }
}

