/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.integration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.jbpm.console.ng.bd.integration.KieServerDataSetManager;
import org.jbpm.console.ng.bd.integration.KieServerIntegration;
import org.jbpm.console.ng.ga.events.KieServerDataSetRegistered;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerDataSetManagerTest {
    private DataSetDefRegistry dataSetDefRegistry;
    private KieServerIntegration kieServerIntegration;
    private Event<KieServerDataSetRegistered> event;
    private final List<Object> receivedEvents = new ArrayList<Object>();
    private KieServicesClient kieClient;
    private QueryServicesClient queryClient;
    private KieServerDataSetManager kieServerDataSetManager;

    @Before
    public void setup() {
        this.dataSetDefRegistry = (DataSetDefRegistry)Mockito.mock(DataSetDefRegistry.class);
        this.kieServerIntegration = (KieServerIntegration)Mockito.mock(KieServerIntegration.class);
        this.event = new EventSourceMock<KieServerDataSetRegistered>(){

            public void fire(KieServerDataSetRegistered event) {
                KieServerDataSetManagerTest.this.receivedEvents.add(event);
            }
        };
        this.kieClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        this.queryClient = (QueryServicesClient)Mockito.mock(QueryServicesClient.class);
        Mockito.when((Object)this.kieClient.getServicesClient((Class)Mockito.any())).thenReturn((Object)this.queryClient);
        Mockito.when((Object)this.kieServerIntegration.getAdminServerClient(Mockito.anyString())).thenReturn((Object)this.kieClient);
        this.kieServerDataSetManager = new KieServerDataSetManager(this.dataSetDefRegistry, this.kieServerIntegration, this.event);
    }

    @Test
    public void testRegisterQueriesWithoutRetry() throws Exception {
        QueryDefinition query = QueryDefinition.builder().name("test").expression("expression").source("jbpm").target("CUSTOM").build();
        HashSet<QueryDefinition> definitions = new HashSet<QueryDefinition>();
        definitions.add(query);
        this.kieServerDataSetManager.registerQueriesWithRetry("template", "instance", definitions);
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClient(Mockito.anyString());
        ((QueryServicesClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Mockito.any());
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRegisterQueriesWithRetryDueToKieServicesException() throws Exception {
        this.registerQueriesWithRetryException((Exception)new KieServicesException("KieServer still starting"));
    }

    @Test
    public void testRegisterQueriesWithRetryDueToKieRemoteHttpRequestException() throws Exception {
        this.registerQueriesWithRetryException((Exception)new KieServerHttpRequestException("KieServer endpoint down"));
    }

    private void registerQueriesWithRetryException(Exception exception) throws Exception {
        QueryDefinition query = QueryDefinition.builder().name("test").expression("expression").source("jbpm").target("CUSTOM").build();
        HashSet<QueryDefinition> definitions = new HashSet<QueryDefinition>();
        definitions.add(query);
        KieServicesClient kieClientRecreated = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        QueryServicesClient queryClientRecreated = (QueryServicesClient)Mockito.mock(QueryServicesClient.class);
        Mockito.when((Object)kieClientRecreated.getServicesClient((Class)Mockito.any())).thenReturn((Object)queryClientRecreated);
        Mockito.when((Object)this.kieServerIntegration.getAdminServerClientCheckEndpoints(Mockito.anyString())).thenReturn((Object)kieClientRecreated);
        ((QueryServicesClient)Mockito.doThrow((Throwable)exception).when((Object)this.queryClient)).replaceQuery((QueryDefinition)Mockito.any());
        this.kieServerDataSetManager.registerQueriesWithRetry("template", "instance", definitions);
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClient(Mockito.anyString());
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClientCheckEndpoints(Mockito.anyString());
        ((QueryServicesClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Mockito.any());
        ((QueryServicesClient)Mockito.verify((Object)queryClientRecreated, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Mockito.any());
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
    }
}

