/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.list;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.client.editors.deployment.list.DeploymentUnitsListPresenter;
import org.jbpm.console.ng.bd.client.editors.deployment.newunit.NewDeploymentPopup;
import org.jbpm.console.ng.bd.client.i18n.Constants;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.events.DeployedUnitChangedEvent;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;

@Dependent
public class DeploymentUnitsListViewImpl
extends AbstractListView<KModuleDeploymentUnitSummary, DeploymentUnitsListPresenter>
implements DeploymentUnitsListPresenter.DeploymentUnitsListView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private NewDeploymentPopup newDeploymentPopup;

    public void init(DeploymentUnitsListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(this.constants.Deployment());
        bannedColumns.add(this.constants.Actions());
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(this.constants.Deployment());
        initColumns.add(this.constants.Strategy());
        initColumns.add(this.constants.Status());
        initColumns.add(this.constants.Actions());
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("DeploymentUnitsGrid", initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DeploymentUnitsListViewImpl.this.selectedRow == -1) {
                    DeploymentUnitsListViewImpl.this.listGrid.setRowStyles(DeploymentUnitsListViewImpl.this.selectedStyles);
                    DeploymentUnitsListViewImpl.this.selectedRow = DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DeploymentUnitsListViewImpl.this.listGrid.redraw();
                } else if (DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow() != DeploymentUnitsListViewImpl.this.selectedRow) {
                    DeploymentUnitsListViewImpl.this.listGrid.setRowStyles(DeploymentUnitsListViewImpl.this.selectedStyles);
                    DeploymentUnitsListViewImpl.this.selectedRow = DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DeploymentUnitsListViewImpl.this.listGrid.redraw();
                } else {
                    close = true;
                }
                DeploymentUnitsListViewImpl.this.selectedItem = (GenericSummary)DeploymentUnitsListViewImpl.this.selectionModel.getLastSelectedObject();
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<KModuleDeploymentUnitSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<KModuleDeploymentUnitSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<KModuleDeploymentUnitSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && DeploymentUnitsListViewImpl.this.listGrid.getColumnIndex(DeploymentUnitsListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        Button newUnitButton = new Button();
        newUnitButton.setIcon(IconType.PLUS);
        newUnitButton.setTitle(Constants.INSTANCE.Deploy_A_New_Unit());
        newUnitButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DeploymentUnitsListViewImpl.this.newDeploymentPopup.show();
            }
        });
        this.listGrid.getLeftToolbar().add((Widget)newUnitButton);
        this.listGrid.setEmptyTableCaption(this.constants.No_Deployment_Units_Available());
        this.listGrid.setRowStyles(this.selectedStyles);
    }

    public void initColumns() {
        Column<KModuleDeploymentUnitSummary, ?> unitIdColumn = this.idColumn();
        Column<KModuleDeploymentUnitSummary, ?> groupIdColumn = this.groupIdColumn();
        Column<KModuleDeploymentUnitSummary, ?> artifactIdColumn = this.artifactIdColumn();
        Column<KModuleDeploymentUnitSummary, ?> versionColumn = this.versionColumn();
        Column<KModuleDeploymentUnitSummary, ?> kbaseColumn = this.kbaseColumn();
        Column<KModuleDeploymentUnitSummary, ?> ksessionColumn = this.ksessionColumn();
        Column<KModuleDeploymentUnitSummary, ?> strategyColumn = this.strategyColumn();
        Column<KModuleDeploymentUnitSummary, ?> statusColumn = this.statusColumn();
        this.actionsColumn = this.actionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(unitIdColumn, this.constants.Deployment()));
        columnMetas.add(new ColumnMeta(groupIdColumn, this.constants.GroupID()));
        columnMetas.add(new ColumnMeta(artifactIdColumn, this.constants.Artifact()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(kbaseColumn, this.constants.KieBaseName()));
        columnMetas.add(new ColumnMeta(ksessionColumn, this.constants.KieSessionName()));
        columnMetas.add(new ColumnMeta(strategyColumn, this.constants.Strategy()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        this.listGrid.addColumns(columnMetas);
    }

    private Column<KModuleDeploymentUnitSummary, ?> idColumn() {
        Column<KModuleDeploymentUnitSummary, String> unitIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getId();
            }
        };
        unitIdColumn.setSortable(true);
        unitIdColumn.setDataStoreName("Deployment");
        return unitIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> groupIdColumn() {
        Column<KModuleDeploymentUnitSummary, String> groupIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getGroupId();
            }
        };
        groupIdColumn.setSortable(true);
        groupIdColumn.setDataStoreName("GroupId");
        return groupIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> artifactIdColumn() {
        Column<KModuleDeploymentUnitSummary, String> artifactIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getArtifactId();
            }
        };
        artifactIdColumn.setSortable(true);
        artifactIdColumn.setDataStoreName("ArtifactId");
        return artifactIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> versionColumn() {
        Column<KModuleDeploymentUnitSummary, String> versionColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName("Version");
        return versionColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> kbaseColumn() {
        Column<KModuleDeploymentUnitSummary, String> kbaseColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                String kbaseName = unit.getKbaseName();
                if (kbaseName.equals("")) {
                    kbaseName = "DEFAULT";
                }
                return kbaseName;
            }
        };
        kbaseColumn.setDataStoreName("KieBaseName");
        kbaseColumn.setSortable(true);
        return kbaseColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> ksessionColumn() {
        Column<KModuleDeploymentUnitSummary, String> ksessionColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                String ksessionName = unit.getKsessionName();
                if (ksessionName.equals("")) {
                    ksessionName = "DEFAULT";
                }
                return ksessionName;
            }
        };
        ksessionColumn.setDataStoreName("KieSessionName");
        ksessionColumn.setSortable(true);
        return ksessionColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> strategyColumn() {
        Column<KModuleDeploymentUnitSummary, String> strategyColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getStrategy();
            }
        };
        strategyColumn.setSortable(true);
        strategyColumn.setDataStoreName("Strategy");
        return strategyColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> statusColumn() {
        Column<KModuleDeploymentUnitSummary, String> statusColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                if (unit.isActive()) {
                    return DeploymentUnitsListViewImpl.this.constants.Active();
                }
                return DeploymentUnitsListViewImpl.this.constants.NotActive();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName("Status");
        return statusColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> actionsColumn() {
        LinkedList<Object> cells = new LinkedList<Object>();
        cells.add(new ActivateDeactivateActionHasCell(this.constants.Activate(), new ActionCell.Delegate<KModuleDeploymentUnitSummary>(){

            public void execute(KModuleDeploymentUnitSummary unit) {
                ((DeploymentUnitsListPresenter)DeploymentUnitsListViewImpl.this.presenter).activateOrDeactivate((DeploymentUnitSummary)unit, !unit.isActive());
            }
        }));
        cells.add(new DeleteActionHasCell(this.constants.Undeploy(), new ActionCell.Delegate<KModuleDeploymentUnitSummary>(){

            public void execute(KModuleDeploymentUnitSummary unit) {
                if (Window.confirm((String)DeploymentUnitsListViewImpl.this.constants.Undeploy_Question())) {
                    ((DeploymentUnitsListPresenter)DeploymentUnitsListViewImpl.this.presenter).undeployUnit(unit.getId(), unit.getGroupId(), unit.getArtifactId(), unit.getVersion(), unit.getKbaseName(), unit.getKsessionName());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        return new Column<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary>((Cell)cell){

            public KModuleDeploymentUnitSummary getValue(KModuleDeploymentUnitSummary object) {
                return object;
            }
        };
    }

    public void refreshOnChangedUnit(@Observes DeployedUnitChangedEvent event) {
        ((DeploymentUnitsListPresenter)this.presenter).refreshGrid();
    }

    private class ActivateDeactivateActionHasCell
    implements HasCell<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary> {
        private ActionCell<KModuleDeploymentUnitSummary> cell;

        public ActivateDeactivateActionHasCell(String text, ActionCell.Delegate<KModuleDeploymentUnitSummary> delegate) {
            this.cell = new ActionCell<KModuleDeploymentUnitSummary>(text, delegate){

                public void render(Cell.Context context, KModuleDeploymentUnitSummary value, SafeHtmlBuilder sb) {
                    if (value.isActive()) {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DeploymentUnitsListViewImpl.this.constants.Deactivate() + "'>" + DeploymentUnitsListViewImpl.this.constants.Deactivate() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    } else {
                        SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                        mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DeploymentUnitsListViewImpl.this.constants.Activate() + "'>" + DeploymentUnitsListViewImpl.this.constants.Activate() + "</a>");
                        sb.append(mysb.toSafeHtml());
                    }
                }
            };
        }

        public Cell<KModuleDeploymentUnitSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary> getFieldUpdater() {
            return null;
        }

        public KModuleDeploymentUnitSummary getValue(KModuleDeploymentUnitSummary object) {
            return object;
        }
    }

    protected class DeleteActionHasCell
    implements HasCell<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary> {
        private ActionCell<KModuleDeploymentUnitSummary> cell;

        public DeleteActionHasCell(String text, ActionCell.Delegate<KModuleDeploymentUnitSummary> delegate) {
            this.cell = new ActionCell<KModuleDeploymentUnitSummary>(text, delegate){

                public void render(Cell.Context context, KModuleDeploymentUnitSummary value, SafeHtmlBuilder sb) {
                    String title = DeploymentUnitsListViewImpl.this.constants.Undeploy();
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + title + "'>" + title + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<KModuleDeploymentUnitSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary> getFieldUpdater() {
            return null;
        }

        public KModuleDeploymentUnitSummary getValue(KModuleDeploymentUnitSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, DeploymentUnitsListViewImpl> {
    }
}

