/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.newunit;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpBlock;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.client.i18n.Constants;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.events.DeployedUnitChangedEvent;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewDeploymentPopup
extends BaseModal {
    @UiField
    public TabPanel tabPanel;
    @UiField
    public Tab basicTab;
    @UiField
    public Tab advancedTab;
    @UiField
    public TextBox groupText;
    @UiField
    public HelpBlock groupTextErrorMessage;
    @UiField
    public ControlGroup groupControlGroup;
    @UiField
    public TextBox artifactText;
    @UiField
    public HelpBlock artifactTextErrorMessage;
    @UiField
    public ControlGroup artifactControlGroup;
    @UiField
    public TextBox versionText;
    @UiField
    public HelpBlock versionTextErrorMessage;
    @UiField
    public ControlGroup versionControlGroup;
    @UiField
    public TextBox kbaseNameText;
    @UiField
    public TextBox kieSessionNameText;
    @UiField
    public ListBox strategyListBox;
    @UiField
    public ListBox mergeModeListBox;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public ControlGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Event<DeployedUnitChangedEvent> unitChanged;
    private PlaceRequest place;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<DeploymentManagerEntryPoint> deploymentManager;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public NewDeploymentPopup() {
        this.setTitle(Constants.INSTANCE.New_Deployment_Unit());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Deploy_Unit(), new Command(){

            public void execute() {
                NewDeploymentPopup.this.okButton();
            }
        }, IconType.PLUS_SIGN, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show() {
        this.cleanForm();
        super.show();
    }

    private void cancelButton() {
        this.closePopup();
    }

    private void okButton() {
        if (this.validateForm()) {
            String strategy = this.strategyListBox.getValue(this.strategyListBox.getSelectedIndex());
            String mergeMode = this.mergeModeListBox.getValue(this.mergeModeListBox.getSelectedIndex());
            this.deployUnit(this.groupText.getText(), this.artifactText.getText(), this.versionText.getText(), this.kbaseNameText.getText(), this.kieSessionNameText.getText(), strategy, mergeMode);
        }
    }

    public void init() {
        this.cleanForm();
        if (this.strategyListBox == null) {
            this.strategyListBox = new ListBox();
        }
        this.strategyListBox.addItem(Constants.INSTANCE.Singleton(), "SINGLETON");
        this.strategyListBox.addItem(Constants.INSTANCE.Request(), "PER_REQUEST");
        this.strategyListBox.addItem(Constants.INSTANCE.ProcessInstance(), "PER_PROCESS_INSTANCE");
        if (this.mergeModeListBox == null) {
            this.mergeModeListBox = new ListBox();
        }
        this.mergeModeListBox.addItem(Constants.INSTANCE.MergeCollections(), "MERGE_COLLECTIONS");
        this.mergeModeListBox.addItem(Constants.INSTANCE.KeepAll(), "KEEP_ALL");
        this.mergeModeListBox.addItem(Constants.INSTANCE.OverrideAll(), "OVERRIDE_ALL");
        this.mergeModeListBox.addItem(Constants.INSTANCE.OverrideEmpty(), "OVERRIDE_EMPTY");
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public void cleanForm() {
        this.tabPanel.selectTab(0);
        this.basicTab.setActive(true);
        this.advancedTab.setActive(false);
        this.groupTextErrorMessage.setText("");
        this.groupControlGroup.setType(ControlGroupType.NONE);
        this.artifactTextErrorMessage.setText("");
        this.artifactControlGroup.setType(ControlGroupType.NONE);
        this.versionTextErrorMessage.setText("");
        this.versionControlGroup.setType(ControlGroupType.NONE);
        this.errorMessages.setText("");
        this.errorMessagesGroup.setType(ControlGroupType.NONE);
        this.artifactText.setText("");
        this.groupText.setText("");
        this.versionText.setText("");
        this.kbaseNameText.setText("");
        this.kieSessionNameText.setText("");
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        if (this.groupText.getText() != null && this.groupText.getText().trim().length() == 0) {
            this.groupControlGroup.setType(ControlGroupType.ERROR);
            this.groupTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.GroupID()));
            valid = false;
        } else {
            this.groupControlGroup.setType(ControlGroupType.SUCCESS);
            this.groupTextErrorMessage.setText("");
        }
        if (this.artifactText.getText() != null && this.artifactText.getText().trim().length() == 0) {
            this.artifactControlGroup.setType(ControlGroupType.ERROR);
            this.artifactTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.Artifact()));
            valid = false;
        } else {
            this.artifactControlGroup.setType(ControlGroupType.SUCCESS);
            this.artifactTextErrorMessage.setText("");
        }
        if (this.versionText.getText() != null && this.versionText.getText().trim().length() == 0) {
            this.versionControlGroup.setType(ControlGroupType.ERROR);
            this.versionTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.Version()));
            valid = false;
        } else {
            this.versionControlGroup.setType(ControlGroupType.SUCCESS);
            this.versionTextErrorMessage.setText("");
        }
        if (!valid) {
            this.tabPanel.selectTab(0);
        }
        return valid;
    }

    public void deployUnit(final String group, final String artifact, final String version, String kbaseName, String kieSessionName, String strategy, String mergeMode) {
        this.showBusyIndicator(Constants.INSTANCE.Please_Wait());
        ((DeploymentManagerEntryPoint)this.deploymentManager.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                NewDeploymentPopup.this.cleanForm();
                NewDeploymentPopup.this.hideBusyIndicator();
                NewDeploymentPopup.this.displayNotification(" Kjar Deployed " + group + ":" + artifact + ":" + version);
                NewDeploymentPopup.this.unitChanged.fire((Object)new DeployedUnitChangedEvent());
                NewDeploymentPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                NewDeploymentPopup.this.hideBusyIndicator();
                NewDeploymentPopup.this.errorMessagesGroup.setType(ControlGroupType.ERROR);
                NewDeploymentPopup.this.errorMessages.setText(Constants.INSTANCE.UnableCreateDeploymentUnit());
                return true;
            }
        })).deploy((DeploymentUnitSummary)new KModuleDeploymentUnitSummary(group + ":" + artifact + ":" + version, group, artifact, version, kbaseName, kieSessionName, strategy, mergeMode));
    }

    static interface Binder
    extends UiBinder<Widget, NewDeploymentPopup> {
    }
}

