/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.list;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.jbpm.console.ng.bd.client.editors.deployment.list.DeploymentUnitsListViewImpl;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;

@RunWith(value=GwtMockitoTestRunner.class)
public class DeploymentUnitsListViewTest {
    @Mock
    protected ExtendedPagedTable<KModuleDeploymentUnitSummary> currentListGrid;
    @InjectMocks
    private DeploymentUnitsListViewImpl view;

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testKBaseColumnValueSetToDefault() {
        final KModuleDeploymentUnitSummary unitWithNull = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", null, null, "Singleton", "MERGE_COLLECTIONS");
        final KModuleDeploymentUnitSummary unitEmptyString = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", "", "", "Singleton", "MERGE_COLLECTIONS");
        final KModuleDeploymentUnitSummary unitWhiteSpace = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", "    ", "   ", "Singleton", "MERGE_COLLECTIONS");
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    if (!columnMeta.getCaption().equals("KieBaseName")) continue;
                    Column column = columnMeta.getColumn();
                    Object value = column.getValue((Object)unitWithNull);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                    value = column.getValue((Object)unitEmptyString);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                    value = column.getValue((Object)unitWhiteSpace);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testKSessionColumnValueSetToDefault() {
        final KModuleDeploymentUnitSummary unitWithNull = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", null, null, "Singleton", "MERGE_COLLECTIONS");
        final KModuleDeploymentUnitSummary unitEmptyString = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", "", "", "Singleton", "MERGE_COLLECTIONS");
        final KModuleDeploymentUnitSummary unitWhiteSpace = new KModuleDeploymentUnitSummary("a:b:c", "a", "b", "c", "    ", "   ", "Singleton", "MERGE_COLLECTIONS");
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    if (!columnMeta.getCaption().equals("KieSessionName")) continue;
                    Column column = columnMeta.getColumn();
                    Object value = column.getValue((Object)unitWithNull);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                    value = column.getValue((Object)unitEmptyString);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                    value = column.getValue((Object)unitWhiteSpace);
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((Object)"DEFAULT", (Object)value);
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }
}

