/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.client.editors.deployment.list.NewDeploymentUnitMenuBuilder;
import org.jbpm.console.ng.bd.client.i18n.Constants;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Deployments List")
public class DeploymentUnitsListPresenter
extends AbstractScreenListPresenter<KModuleDeploymentUnitSummary>
implements NewDeploymentUnitMenuBuilder.SupportsNewDeploymentUnit {
    @Inject
    protected DeploymentUnitsListView view;
    @Inject
    private Caller<DeploymentManagerEntryPoint> deploymentManagerService;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public DeploymentUnitsListPresenter() {
        this.dataProvider = new AsyncDataProvider<KModuleDeploymentUnitSummary>(){

            protected void onRangeChanged(HasData<KModuleDeploymentUnitSummary> display) {
                DeploymentUnitsListPresenter.this.view.showBusyIndicator(DeploymentUnitsListPresenter.this.constants.Loading());
                Range visibleRange = display.getVisibleRange();
                DeploymentUnitsListPresenter.this.getData(visibleRange);
            }
        };
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true);
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() > 0 ? columnSortList.get(0).isAscending() : true));
        ((DeploymentManagerEntryPoint)this.deploymentManagerService.call((RemoteCallback)new RemoteCallback<PageResponse<KModuleDeploymentUnitSummary>>(){

            public void callback(PageResponse<KModuleDeploymentUnitSummary> response) {
                DeploymentUnitsListPresenter.this.updateDataOnCallback(response);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.ErrorRetrievingDeploymentUnits(throwable.getMessage()));
                GWT.log((String)throwable.toString());
                return true;
            }
        })).getData(this.currentFilter);
    }

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void undeployUnit(String id, final String group, final String artifact, final String version, String kbaseName, String kieSessionName) {
        this.view.showBusyIndicator(this.constants.Please_Wait());
        ((DeploymentManagerEntryPoint)this.deploymentManagerService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.KjarUndeployed(group, artifact, version));
                DeploymentUnitsListPresenter.this.refreshGrid();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.ErrorUndeployFailed());
                return true;
            }
        })).undeploy((DeploymentUnitSummary)new KModuleDeploymentUnitSummary(id, group, artifact, version, kbaseName, kieSessionName, null, null));
    }

    public void activateOrDeactivate(final DeploymentUnitSummary unitSummary, boolean activate) {
        if (activate) {
            this.view.showBusyIndicator(this.constants.Please_Wait());
            ((DeploymentManagerEntryPoint)this.deploymentManagerService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void nothing) {
                    DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                    DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.KjarActivated(unitSummary.getId()));
                    DeploymentUnitsListPresenter.this.refreshGrid();
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                    DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.ErrorActivationFailed());
                    return true;
                }
            })).activate(unitSummary);
        } else {
            this.view.showBusyIndicator(this.constants.Please_Wait());
            ((DeploymentManagerEntryPoint)this.deploymentManagerService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void nothing) {
                    DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                    DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.KjarDeactivated(unitSummary.getId()));
                    DeploymentUnitsListPresenter.this.refreshGrid();
                }
            }, (ErrorCallback)new ErrorCallback<Message>(){

                public boolean error(Message message, Throwable throwable) {
                    DeploymentUnitsListPresenter.this.view.hideBusyIndicator();
                    DeploymentUnitsListPresenter.this.view.displayNotification(DeploymentUnitsListPresenter.this.constants.ErrorDeactivationFailed());
                    return true;
                }
            })).deactivate(unitSummary);
        }
    }

    @WorkbenchPartView
    public UberView<DeploymentUnitsListPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Deployed_Units();
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new NewDeploymentUnitMenuBuilder(this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    @Override
    public void onNewDeploymentUnit() {
        this.view.newDeploymentUnit();
    }

    public static interface DeploymentUnitsListView
    extends AbstractListView.ListView<KModuleDeploymentUnitSummary, DeploymentUnitsListPresenter> {
        public void newDeploymentUnit();
    }
}

