/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.console.ng.bd.client.editors.deployment.list.DeploymentUnitsListPresenter;
import org.jbpm.console.ng.bd.client.editors.deployment.newunit.NewDeploymentPopup;
import org.jbpm.console.ng.bd.client.i18n.Constants;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.events.DeployedUnitChangedEvent;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class DeploymentUnitsListViewImpl
extends AbstractListView<KModuleDeploymentUnitSummary, DeploymentUnitsListPresenter>
implements DeploymentUnitsListPresenter.DeploymentUnitsListView {
    public static final String COL_ID_DEPLOYMENT = "Deployment";
    public static final String COL_ID_GROUP = "GroupId";
    public static final String COL_ID_ARTIFACT = "Artifact";
    public static final String COL_ID_VERSION = "Version";
    public static final String COL_ID_KIEBASENAME = "KieBaseName";
    public static final String COL_ID_KIEBSESSIONNAME = "KieSessionName";
    public static final String COL_ID_STRATEGY = "Strategy";
    public static final String COL_ID_STATUS = "Status";
    public static final String COL_ID_ACTIONS = "Actions";
    private Constants constants = Constants.INSTANCE;
    @Inject
    private NewDeploymentPopup newDeploymentPopup;

    public void init(DeploymentUnitsListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(COL_ID_DEPLOYMENT);
        bannedColumns.add(COL_ID_ACTIONS);
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(COL_ID_DEPLOYMENT);
        initColumns.add(COL_ID_STRATEGY);
        initColumns.add(COL_ID_STATUS);
        initColumns.add(COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("DeploymentUnitsGrid", initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DeploymentUnitsListViewImpl.this.selectedRow == -1) {
                    DeploymentUnitsListViewImpl.this.listGrid.setRowStyles(DeploymentUnitsListViewImpl.this.selectedStyles);
                    DeploymentUnitsListViewImpl.this.selectedRow = DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DeploymentUnitsListViewImpl.this.listGrid.redraw();
                } else if (DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow() != DeploymentUnitsListViewImpl.this.selectedRow) {
                    DeploymentUnitsListViewImpl.this.listGrid.setRowStyles(DeploymentUnitsListViewImpl.this.selectedStyles);
                    DeploymentUnitsListViewImpl.this.selectedRow = DeploymentUnitsListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DeploymentUnitsListViewImpl.this.listGrid.redraw();
                } else {
                    close = true;
                }
                DeploymentUnitsListViewImpl.this.selectedItem = (GenericSummary)DeploymentUnitsListViewImpl.this.selectionModel.getLastSelectedObject();
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<KModuleDeploymentUnitSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<KModuleDeploymentUnitSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<KModuleDeploymentUnitSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && DeploymentUnitsListViewImpl.this.listGrid.getColumnIndex(DeploymentUnitsListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setEmptyTableCaption(this.constants.No_Deployment_Units_Available());
        this.listGrid.setRowStyles(this.selectedStyles);
        this.listGrid.getElement().getStyle().setPaddingRight(20.0, Style.Unit.PX);
        this.listGrid.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        Column<KModuleDeploymentUnitSummary, ?> unitIdColumn = this.idColumn();
        Column<KModuleDeploymentUnitSummary, ?> groupIdColumn = this.groupIdColumn();
        Column<KModuleDeploymentUnitSummary, ?> artifactIdColumn = this.artifactIdColumn();
        Column<KModuleDeploymentUnitSummary, ?> versionColumn = this.versionColumn();
        Column<KModuleDeploymentUnitSummary, ?> kbaseColumn = this.kbaseColumn();
        Column<KModuleDeploymentUnitSummary, ?> ksessionColumn = this.ksessionColumn();
        Column<KModuleDeploymentUnitSummary, ?> strategyColumn = this.strategyColumn();
        Column<KModuleDeploymentUnitSummary, ?> statusColumn = this.statusColumn();
        this.actionsColumn = this.actionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(unitIdColumn, this.constants.Deployment()));
        columnMetas.add(new ColumnMeta(groupIdColumn, this.constants.GroupID()));
        columnMetas.add(new ColumnMeta(artifactIdColumn, this.constants.Artifact()));
        columnMetas.add(new ColumnMeta(versionColumn, this.constants.Version()));
        columnMetas.add(new ColumnMeta(kbaseColumn, this.constants.KieBaseName()));
        columnMetas.add(new ColumnMeta(ksessionColumn, this.constants.KieSessionName()));
        columnMetas.add(new ColumnMeta(strategyColumn, this.constants.Strategy()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        this.listGrid.addColumns(columnMetas);
    }

    private Column<KModuleDeploymentUnitSummary, ?> idColumn() {
        Column<KModuleDeploymentUnitSummary, String> unitIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getId();
            }
        };
        unitIdColumn.setSortable(true);
        unitIdColumn.setDataStoreName(COL_ID_DEPLOYMENT);
        return unitIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> groupIdColumn() {
        Column<KModuleDeploymentUnitSummary, String> groupIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getGroupId();
            }
        };
        groupIdColumn.setSortable(true);
        groupIdColumn.setDataStoreName(COL_ID_GROUP);
        return groupIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> artifactIdColumn() {
        Column<KModuleDeploymentUnitSummary, String> artifactIdColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getArtifactId();
            }
        };
        artifactIdColumn.setSortable(true);
        artifactIdColumn.setDataStoreName(COL_ID_ARTIFACT);
        return artifactIdColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> versionColumn() {
        Column<KModuleDeploymentUnitSummary, String> versionColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getVersion();
            }
        };
        versionColumn.setSortable(true);
        versionColumn.setDataStoreName(COL_ID_VERSION);
        return versionColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> kbaseColumn() {
        Column<KModuleDeploymentUnitSummary, String> kbaseColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                String kbaseName = unit.getKbaseName();
                if (kbaseName == null || kbaseName.trim().isEmpty()) {
                    kbaseName = "DEFAULT";
                }
                return kbaseName;
            }
        };
        kbaseColumn.setDataStoreName(COL_ID_KIEBASENAME);
        kbaseColumn.setSortable(true);
        return kbaseColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> ksessionColumn() {
        Column<KModuleDeploymentUnitSummary, String> ksessionColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                String ksessionName = unit.getKsessionName();
                if (ksessionName == null || ksessionName.trim().isEmpty()) {
                    ksessionName = "DEFAULT";
                }
                return ksessionName;
            }
        };
        ksessionColumn.setDataStoreName(COL_ID_KIEBSESSIONNAME);
        ksessionColumn.setSortable(true);
        return ksessionColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> strategyColumn() {
        Column<KModuleDeploymentUnitSummary, String> strategyColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                return unit.getStrategy();
            }
        };
        strategyColumn.setSortable(true);
        strategyColumn.setDataStoreName(COL_ID_STRATEGY);
        return strategyColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> statusColumn() {
        Column<KModuleDeploymentUnitSummary, String> statusColumn = new Column<KModuleDeploymentUnitSummary, String>((Cell)new TextCell()){

            public String getValue(KModuleDeploymentUnitSummary unit) {
                if (unit.isActive()) {
                    return DeploymentUnitsListViewImpl.this.constants.Active();
                }
                return DeploymentUnitsListViewImpl.this.constants.NotActive();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName(COL_ID_STATUS);
        return statusColumn;
    }

    private Column<KModuleDeploymentUnitSummary, ?> actionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ActivateDeactivateActionHasCell(new ActionCell.Delegate<KModuleDeploymentUnitSummary>(){

            public void execute(KModuleDeploymentUnitSummary unit) {
                ((DeploymentUnitsListPresenter)DeploymentUnitsListViewImpl.this.presenter).activateOrDeactivate((DeploymentUnitSummary)unit, !unit.isActive());
            }
        }));
        cells.add(new ButtonActionCell(this.constants.Undeploy(), (ActionCell.Delegate)new ActionCell.Delegate<KModuleDeploymentUnitSummary>(){

            public void execute(KModuleDeploymentUnitSummary unit) {
                if (Window.confirm((String)DeploymentUnitsListViewImpl.this.constants.Undeploy_Question())) {
                    ((DeploymentUnitsListPresenter)DeploymentUnitsListViewImpl.this.presenter).undeployUnit(unit.getId(), unit.getGroupId(), unit.getArtifactId(), unit.getVersion(), unit.getKbaseName(), unit.getKsessionName());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary> actionColum = new Column<KModuleDeploymentUnitSummary, KModuleDeploymentUnitSummary>((Cell)cell){

            public KModuleDeploymentUnitSummary getValue(KModuleDeploymentUnitSummary object) {
                return object;
            }
        };
        actionColum.setDataStoreName(COL_ID_ACTIONS);
        return actionColum;
    }

    public void refreshOnChangedUnit(@Observes DeployedUnitChangedEvent event) {
        ((DeploymentUnitsListPresenter)this.presenter).refreshGrid();
    }

    @Override
    public void newDeploymentUnit() {
        this.newDeploymentPopup.show();
    }

    private class ActivateDeactivateActionHasCell
    extends ButtonActionCell<KModuleDeploymentUnitSummary> {
        public ActivateDeactivateActionHasCell(ActionCell.Delegate<KModuleDeploymentUnitSummary> delegate) {
            super(delegate);
        }

        public String getText(KModuleDeploymentUnitSummary value) {
            return value.isActive() ? DeploymentUnitsListViewImpl.this.constants.Deactivate() : DeploymentUnitsListViewImpl.this.constants.Activate();
        }
    }

    static interface Binder
    extends UiBinder<Widget, DeploymentUnitsListViewImpl> {
    }
}

