/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.bd.client.editors.deployment.newunit;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.TabPanel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.console.ng.bd.client.i18n.Constants;
import org.jbpm.console.ng.bd.model.DeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.KModuleDeploymentUnitSummary;
import org.jbpm.console.ng.bd.model.events.DeployedUnitChangedEvent;
import org.jbpm.console.ng.bd.service.DeploymentManagerEntryPoint;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewDeploymentPopup
extends BaseModal {
    @UiField
    public TabPanel tabPanel;
    @UiField
    public TabListItem basicTab;
    @UiField
    public TabListItem advancedTab;
    @UiField
    public TabPane basicTabPane;
    @UiField
    public TabPane advancedTabPane;
    @UiField
    public TextBox groupText;
    @UiField
    public HelpBlock groupTextErrorMessage;
    @UiField
    public FormGroup groupControlGroup;
    @UiField
    public TextBox artifactText;
    @UiField
    public HelpBlock artifactTextErrorMessage;
    @UiField
    public FormGroup artifactControlGroup;
    @UiField
    public TextBox versionText;
    @UiField
    public HelpBlock versionTextErrorMessage;
    @UiField
    public FormGroup versionControlGroup;
    @UiField
    public TextBox kbaseNameText;
    @UiField
    public TextBox kieSessionNameText;
    @UiField
    public ListBox strategyListBox;
    @UiField
    public ListBox mergeModeListBox;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @Inject
    private Event<NotificationEvent> notification;
    @Inject
    private Event<DeployedUnitChangedEvent> unitChanged;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private Caller<DeploymentManagerEntryPoint> deploymentManager;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public NewDeploymentPopup() {
        this.setTitle(Constants.INSTANCE.New_Deployment_Unit());
        this.setBody((Widget)uiBinder.createAndBindUi((Object)this));
        this.basicTab.setDataTargetWidget((Widget)this.basicTabPane);
        this.advancedTab.setDataTargetWidget((Widget)this.advancedTabPane);
        this.init();
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(Constants.INSTANCE.Deploy_Unit(), new Command(){

            public void execute() {
                NewDeploymentPopup.this.okButton();
            }
        }, IconType.PLUS, ButtonType.PRIMARY);
        this.add((Widget)footer);
    }

    public void show() {
        this.cleanForm();
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            String strategy = this.strategyListBox.getValue(this.strategyListBox.getSelectedIndex());
            String mergeMode = this.mergeModeListBox.getValue(this.mergeModeListBox.getSelectedIndex());
            this.deployUnit(this.groupText.getText(), this.artifactText.getText(), this.versionText.getText(), this.kbaseNameText.getText(), this.kieSessionNameText.getText(), strategy, mergeMode);
        }
    }

    public void init() {
        this.cleanForm();
        if (this.strategyListBox == null) {
            this.strategyListBox = new ListBox();
        }
        this.strategyListBox.addItem(Constants.INSTANCE.Singleton(), "SINGLETON");
        this.strategyListBox.addItem(Constants.INSTANCE.Request(), "PER_REQUEST");
        this.strategyListBox.addItem(Constants.INSTANCE.ProcessInstance(), "PER_PROCESS_INSTANCE");
        if (this.mergeModeListBox == null) {
            this.mergeModeListBox = new ListBox();
        }
        this.mergeModeListBox.addItem(Constants.INSTANCE.MergeCollections(), "MERGE_COLLECTIONS");
        this.mergeModeListBox.addItem(Constants.INSTANCE.KeepAll(), "KEEP_ALL");
        this.mergeModeListBox.addItem(Constants.INSTANCE.OverrideAll(), "OVERRIDE_ALL");
        this.mergeModeListBox.addItem(Constants.INSTANCE.OverrideEmpty(), "OVERRIDE_EMPTY");
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    public void cleanForm() {
        this.basicTab.showTab();
        this.basicTab.setActive(true);
        this.advancedTab.setActive(false);
        this.groupTextErrorMessage.setText("");
        this.groupControlGroup.setValidationState(ValidationState.NONE);
        this.artifactTextErrorMessage.setText("");
        this.artifactControlGroup.setValidationState(ValidationState.NONE);
        this.versionTextErrorMessage.setText("");
        this.versionControlGroup.setValidationState(ValidationState.NONE);
        this.errorMessages.setText("");
        this.errorMessagesGroup.setValidationState(ValidationState.NONE);
        this.artifactText.setText("");
        this.groupText.setText("");
        this.versionText.setText("");
        this.kbaseNameText.setText("");
        this.kieSessionNameText.setText("");
    }

    public void closePopup() {
        this.cleanForm();
        this.hide();
        super.hide();
    }

    private boolean validateForm() {
        boolean valid = true;
        if (this.groupText.getText() != null && this.groupText.getText().trim().length() == 0) {
            this.groupControlGroup.setValidationState(ValidationState.ERROR);
            this.groupTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.GroupID()));
            valid = false;
        } else {
            this.groupControlGroup.setValidationState(ValidationState.SUCCESS);
            this.groupTextErrorMessage.setText("");
        }
        if (this.artifactText.getText() != null && this.artifactText.getText().trim().length() == 0) {
            this.artifactControlGroup.setValidationState(ValidationState.ERROR);
            this.artifactTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.Artifact()));
            valid = false;
        } else {
            this.artifactControlGroup.setValidationState(ValidationState.SUCCESS);
            this.artifactTextErrorMessage.setText("");
        }
        if (this.versionText.getText() != null && this.versionText.getText().trim().length() == 0) {
            this.versionControlGroup.setValidationState(ValidationState.ERROR);
            this.versionTextErrorMessage.setText(Constants.INSTANCE.ShouldProvide(Constants.INSTANCE.Version()));
            valid = false;
        } else {
            this.versionControlGroup.setValidationState(ValidationState.SUCCESS);
            this.versionTextErrorMessage.setText("");
        }
        if (!valid) {
            this.basicTab.showTab();
        }
        return valid;
    }

    public void deployUnit(final String group, final String artifact, final String version, String kbaseName, String kieSessionName, String strategy, String mergeMode) {
        this.showBusyIndicator(Constants.INSTANCE.Please_Wait());
        ((DeploymentManagerEntryPoint)this.deploymentManager.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void nothing) {
                NewDeploymentPopup.this.cleanForm();
                NewDeploymentPopup.this.hideBusyIndicator();
                NewDeploymentPopup.this.displayNotification(Constants.INSTANCE.KjarDeployed(group, artifact, version));
                NewDeploymentPopup.this.unitChanged.fire((Object)new DeployedUnitChangedEvent());
                NewDeploymentPopup.this.closePopup();
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                NewDeploymentPopup.this.hideBusyIndicator();
                NewDeploymentPopup.this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
                NewDeploymentPopup.this.errorMessages.setText(Constants.INSTANCE.UnableCreateDeploymentUnit());
                return true;
            }
        })).deploy((DeploymentUnitSummary)new KModuleDeploymentUnitSummary(group + ":" + artifact + ":" + version, group, artifact, version, kbaseName, kieSessionName, strategy, mergeMode));
    }

    static interface Binder
    extends UiBinder<Widget, NewDeploymentPopup> {
    }
}

