/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseCommentsPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock
    CaseCommentsPresenter.CaseCommentsView caseCommentsView;
    @Mock
    User identity;
    @InjectMocks
    CaseCommentsPresenter presenter;
    private final String commentId = "commentId";
    private final String author = "author";
    private final String text = "text";
    private final Date addedAt = new Date();
    private final String serverTemplateId = "serverTemplateId";

    public CaseCommentsPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testLoadCaseInstance() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments("serverTemplateId", cis.getContainerId(), cis.getCaseId())).thenReturn(Collections.singletonList(caseComment));
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"author");
        this.setupCaseInstance(cis, "serverTemplateId");
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView)).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(1);
    }

    @Test
    public void testAddCaseComment() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        this.setupCaseInstance(cis, "serverTemplateId");
        this.presenter.addCaseComment(caseComment);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addComment((String)Matchers.eq((Object)"serverTemplateId"), (String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"author"), (String)Matchers.eq((Object)"text"));
        this.verifyClearCaseInstance(2);
    }

    @Test
    public void testUpdateCaseComment() {
        String newCommentText = "newCommentText";
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"author");
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments("serverTemplateId", cis.getContainerId(), cis.getCaseId())).thenReturn(Collections.singletonList(caseComment));
        this.setupCaseInstance(cis, "serverTemplateId");
        this.presenter.updateCaseComment(caseComment, newCommentText);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).updateComment((String)Matchers.eq((Object)"serverTemplateId"), (String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"commentId"), (String)Matchers.eq((Object)"author"), (String)Matchers.eq((Object)newCommentText));
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)2))).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(2);
    }

    @Test
    public void testDeleteComment() {
        CaseInstanceSummary cis = CaseCommentsPresenterTest.newCaseInstanceSummary();
        CaseCommentSummary caseComment = CaseCommentSummary.builder().id("commentId").author("author").text("text").addedAt(this.addedAt).build();
        Mockito.when((Object)this.caseManagementService.getComments("serverTemplateId", cis.getContainerId(), cis.getCaseId())).thenReturn(Collections.singletonList(caseComment));
        this.setupCaseInstance(cis, "serverTemplateId");
        this.presenter.deleteCaseComment(caseComment);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeComment((String)Matchers.eq((Object)"serverTemplateId"), (String)Matchers.eq((Object)cis.getContainerId()), (String)Matchers.eq((Object)cis.getCaseId()), (String)Matchers.eq((Object)"commentId"));
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)2))).setCaseCommentList(Collections.singletonList(caseComment));
        this.verifyClearCaseInstance(2);
    }

    @Test
    public void onStartupShouldNotCallCaseService_whenAnyParameterNull() {
        String[][] invalidPlaceRequestParams = new String[][]{{null, null, null}, {null, null, "caseId"}, {null, "containerId", null}, {"serverTemplateId", null, null}, {"serverTemplateId", null, "caseId"}, {"serverTemplateId", "containerId", null}};
        Arrays.stream(invalidPlaceRequestParams).forEach(invalidParams -> this.verifyGetCaseInstanceCalled((String[])invalidParams, 0));
        String[] validPlaceRequestParams = new String[]{"serverTemplateId", "containerId", "caseId"};
        this.verifyGetCaseInstanceCalled(validPlaceRequestParams, 1);
    }

    private void verifyClearCaseInstance(int times) {
        ((CaseCommentsPresenter.CaseCommentsView)Mockito.verify((Object)this.caseCommentsView, (VerificationMode)Mockito.times((int)times))).clearCommentInputForm();
    }

    private void verifyGetCaseInstanceCalled(String[] placeRequestParams, int timesCalled) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverTemplateId", placeRequestParams[0]);
        params.put("containerId", placeRequestParams[1]);
        params.put("caseId", placeRequestParams[2]);
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("Case Comments", params, false);
        this.presenter.onStartup((PlaceRequest)placeRequest);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)timesCalled))).getCaseInstance(Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }
}

