/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.stages;

import com.google.common.collect.Lists;
import java.util.List;
import org.jbpm.console.ng.cm.client.stages.CaseStagesPresenter;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.console.ng.cm.client.util.CaseStageStatus;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseStageSummary;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseStagesPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock
    CaseStagesPresenter.CaseStagesView caseStagesView;
    @InjectMocks
    CaseStagesPresenter presenter;
    CaseInstanceSummary cis;
    static final String serverTemplateId = "serverTemplateId";
    static final String containerId = "containerId";
    static final String caseDefId = "caseDefinitionId";
    static final String caseId = "caseId";

    public CaseStagesPresenter getPresenter() {
        return this.presenter;
    }

    private static CaseStageSummary createCaseStageSummary() {
        return CaseStageSummary.builder().identifier("stage1").name("stageName").status(CaseStageStatus.AVAILABLE.getStatus()).build();
    }

    private static CaseInstanceSummary createCaseInstance() {
        return CaseInstanceSummary.builder().caseId(caseId).caseDefinitionId(caseDefId).description("description").status(Integer.valueOf(1)).containerId(containerId).stages((List)Lists.newArrayList((Object[])new CaseStageSummary[]{CaseStagesPresenterTest.createCaseStageSummary()})).build();
    }

    @Override
    @Before
    public void init() {
        this.cis = CaseStagesPresenterTest.createCaseInstance();
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.cis = CaseInstanceSummary.builder().containerId(containerId).caseId(caseId).caseDefinitionId(caseDefId).build();
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id(caseDefId).build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(serverTemplateId, this.cis.getContainerId(), this.cis.getCaseDefinitionId())).thenReturn((Object)cds);
        Mockito.when((Object)this.caseManagementService.getCaseInstance(serverTemplateId, containerId, caseId)).thenReturn((Object)this.cis);
    }

    @Test
    public void testClearCaseInstance() {
        this.presenter.clearCaseInstance();
        this.verifyClearCaseInstance();
    }

    private void verifyClearCaseInstance() {
        ((CaseStagesPresenter.CaseStagesView)Mockito.verify((Object)this.caseStagesView)).removeAllStages();
    }

    @Test
    public void testLoadCaseInstance() {
        this.setupCaseInstance(this.cis, serverTemplateId);
        this.verifyClearCaseInstance();
        ((CaseStagesPresenter.CaseStagesView)Mockito.verify((Object)this.caseStagesView)).setCaseStagesList(this.cis.getStages());
    }
}

