/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import com.google.common.base.Strings;
import com.google.gwt.user.client.TakesValue;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.console.ng.cm.client.events.CaseCommentEditEvent;
import org.jbpm.console.ng.cm.client.util.AbstractView;
import org.jbpm.console.ng.cm.client.util.DateConverter;
import org.jbpm.console.ng.cm.client.util.FormGroup;
import org.jbpm.console.ng.cm.client.util.ValidationState;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;

@Dependent
@Templated
public class CaseCommentItemView
extends AbstractView<CaseCommentsPresenter>
implements TakesValue<CaseCommentSummary>,
IsElement {
    @Inject
    @DataField(value="comment-author")
    @Bound
    Span author;
    @Inject
    @DataField(value="comment-text")
    @Bound(property="text")
    Span text;
    @Inject
    @DataField(value="comment-addedat")
    @Bound(converter=DateConverter.class)
    Span addedAt;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    @DataField(value="comment-update-input")
    TextInput updateCommentText;
    @Inject
    @DataField(value="comment-update-help")
    Span updateCommentTextHelp;
    @Inject
    @DataField(value="comment-update-group")
    FormGroup updateCommentTextGroup;
    @Inject
    @DataField(value="comment-show")
    Div commentShowGroup;
    @Inject
    @DataField(value="comment-update")
    Div commentUpdate;
    @Inject
    @AutoBound
    private DataBinder<CaseCommentSummary> caseCommentSummary;
    @Inject
    private TranslationService translationService;
    @Inject
    User identity;
    private Event<CaseCommentEditEvent> commentEditEvent;
    CaseCommentsPresenter.CaseCommentAction updateCommandAction;
    boolean editMode = false;

    @Inject
    public void setCommentEditEvent(Event<CaseCommentEditEvent> commentEditEvent) {
        this.commentEditEvent = commentEditEvent;
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public void addAction(CaseCommentsPresenter.CaseCommentAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        a.setOnclick(e -> action.execute());
        HTMLElement li = Window.getDocument().createElement("li");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void addUpdateCommentAction(CaseCommentsPresenter.CaseCommentAction action) {
        this.updateCommandAction = action;
        this.addAction(action);
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        this.updateActions(editMode);
        if (editMode) {
            DOMUtil.addCSSClass((HTMLElement)this.commentShowGroup, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.commentUpdate, (String)"hidden");
            this.updateCommentText.setValue(this.getValue().getText());
            this.updateCommentText.focus();
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.commentUpdate, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.commentShowGroup, (String)"hidden");
        }
    }

    public void clearErrorMessages() {
        this.updateCommentTextHelp.setTextContent("");
        this.updateCommentTextGroup.clearValidationState();
    }

    public boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.updateCommentText.getValue());
        if (newCommentEmpty) {
            this.updateCommentText.focus();
            this.updateCommentTextHelp.setTextContent(this.translationService.format("CommentCannotBeEmpty", new Object[0]));
            this.updateCommentTextGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }

    @EventHandler(value={"comment-update-input"})
    public void updateCommentPressingEnter(@ForEvent(value={"keyup"}) KeyboardEvent e) {
        if ("Enter".equals(e.getKey()) || "Enter".equals(e.getCode()) || "NumpadEnter".equals(e.getCode())) {
            this.updateCommandAction.execute();
        }
    }

    public CaseCommentSummary getValue() {
        return (CaseCommentSummary)this.caseCommentSummary.getModel();
    }

    public void setValue(CaseCommentSummary model) {
        this.caseCommentSummary.setModel((Object)model);
        this.setEditMode(false);
    }

    protected void updateActions(boolean editItem) {
        this.actionsItems.setInnerHTML("");
        if (this.identity.getIdentifier().equals(this.getValue().getAuthor())) {
            this.addAction(new CaseCommentsPresenter.CaseCommentAction(){

                @Override
                public String label() {
                    return CaseCommentItemView.this.translationService.format("Delete", new Object[0]);
                }

                public void execute() {
                    ((CaseCommentsPresenter)CaseCommentItemView.this.presenter).deleteCaseComment(CaseCommentItemView.this.getValue());
                }
            });
            if (editItem) {
                this.addUpdateCommentAction(new CaseCommentsPresenter.CaseCommentAction(){

                    @Override
                    public String label() {
                        return CaseCommentItemView.this.translationService.format("Save", new Object[0]);
                    }

                    public void execute() {
                        if (CaseCommentItemView.this.validateForm()) {
                            ((CaseCommentsPresenter)CaseCommentItemView.this.presenter).updateCaseComment(CaseCommentItemView.this.getValue(), CaseCommentItemView.this.updateCommentText.getValue());
                        }
                    }
                });
                this.addAction(new CaseCommentsPresenter.CaseCommentAction(){

                    @Override
                    public String label() {
                        return CaseCommentItemView.this.translationService.format("Cancel", new Object[0]);
                    }

                    public void execute() {
                        CaseCommentItemView.this.setEditMode(false);
                    }
                });
            } else {
                this.addAction(new CaseCommentsPresenter.CaseCommentAction(){

                    @Override
                    public String label() {
                        return CaseCommentItemView.this.translationService.format("Edit", new Object[0]);
                    }

                    public void execute() {
                        CaseCommentItemView.this.commentEditEvent.fire((Object)new CaseCommentEditEvent(CaseCommentItemView.this.getValue().getId()));
                    }
                });
            }
        }
    }

    public void onCaseCommentEditEvent(@Observes CaseCommentEditEvent event) {
        if (event.getCommentId().equals(this.getValue().getId())) {
            this.setEditMode(true);
        } else if (this.editMode) {
            this.setEditMode(false);
        }
    }
}

