/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import com.google.common.base.Strings;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.components.ListComponent;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.comments.CaseCommentItemView;
import org.jbpm.console.ng.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.console.ng.cm.client.util.AbstractView;
import org.jbpm.console.ng.cm.client.util.FormGroup;
import org.jbpm.console.ng.cm.client.util.ValidationState;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;

@Dependent
@Templated
public class CaseCommentsViewImpl
extends AbstractView<CaseCommentsPresenter>
implements CaseCommentsPresenter.CaseCommentsView {
    @Inject
    @DataField(value="comments")
    Div commentsContainer;
    @Inject
    @Bound
    @DataField(value="comments-list")
    private ListComponent<CaseCommentSummary, CaseCommentItemView> comments;
    @Inject
    @AutoBound
    private DataBinder<List<CaseCommentSummary>> caseCommentList;
    @Inject
    @DataField(value="empty-list-item")
    private Div emptyContainer;
    @Inject
    @DataField(value="comment-creation-input")
    TextInput newCommentTextArea;
    @Inject
    @DataField(value="comment-creation-help")
    Span newCommentTextAreaHelp;
    @Inject
    @DataField(value="comment-creation-group")
    FormGroup newCommentTextAreaGroup;
    @Inject
    @DataField
    Anchor addCommentButton;
    @Inject
    private TranslationService translationService;

    public HTMLElement getElement() {
        return this.commentsContainer;
    }

    @Override
    public void init(CaseCommentsPresenter presenter) {
        this.presenter = presenter;
        this.comments.addComponentCreationHandler(v -> v.init(presenter));
    }

    @Override
    public void clearCommentInputForm() {
        this.newCommentTextArea.setValue("");
        this.clearErrorMessages();
    }

    public void clearErrorMessages() {
        this.newCommentTextAreaHelp.setTextContent("");
        this.newCommentTextAreaGroup.clearValidationState();
    }

    @Override
    public void setCaseCommentList(List<CaseCommentSummary> caseCommentList) {
        this.caseCommentList.setModel(caseCommentList);
        if (caseCommentList.isEmpty()) {
            DOMUtil.removeCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.emptyContainer, (String)"hidden");
        }
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(@ForEvent(value={"click"}) Event e) {
        this.submitCommentAddition();
    }

    @EventHandler(value={"comment-creation-input"})
    public void addCommentPressingEnter(@ForEvent(value={"keyup"}) KeyboardEvent e) {
        if ("Enter".equals(e.getKey()) || "Enter".equals(e.getCode()) || "NumpadEnter".equals(e.getCode())) {
            this.submitCommentAddition();
        }
    }

    private void submitCommentAddition() {
        if (this.validateForm()) {
            ((CaseCommentsPresenter)this.presenter).addCaseComment(this.newCommentTextArea.getValue());
        }
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.newCommentTextArea.getValue());
        if (newCommentEmpty) {
            this.newCommentTextArea.focus();
            this.newCommentTextAreaHelp.setTextContent(this.translationService.format("CommentCannotBeEmpty", new Object[0]));
            this.newCommentTextAreaGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }
}

