/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.details;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import org.jbpm.console.ng.cm.client.AbstractCaseInstancePresenterTest;
import org.jbpm.console.ng.cm.client.details.CaseDetailsPresenter;
import org.jbpm.console.ng.cm.client.events.CaseRefreshEvent;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CaseDetailsPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock
    CaseDetailsPresenter.CaseDetailsView view;
    @InjectMocks
    CaseDetailsPresenter presenter;

    public CaseDetailsPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testFindCaseInstance() {
        this.presenter.findCaseInstance();
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseId("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStatus("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseDescription("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStartedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseCompletedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseOwner("");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.never())).getCaseInstance(Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testOnStartup() {
        String serverTemplateId = "serverTemplateId";
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseId("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStatus("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseDescription("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStartedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseCompletedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseOwner("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseId(cis.getCaseId());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStatus(cis.getStatusString());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseDescription(cis.getDescription());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseStartedAt(DateUtils.getDateTimeStr((Date)cis.getStartedAt()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseCompletedAt(DateUtils.getDateTimeStr((Date)cis.getCompletedAt()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view)).setCaseOwner(cis.getOwner());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
    }

    @Test
    public void testOnCaseRefreshEvent() {
        String serverTemplateId = "serverTemplateId";
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.onCaseRefreshEvent(new CaseRefreshEvent(cis.getCaseId()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseId("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseStatus("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseDescription("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseStartedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseCompletedAt("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseOwner("");
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseId(cis.getCaseId());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseStatus(cis.getStatusString());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseDescription(cis.getDescription());
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseStartedAt(DateUtils.getDateTimeStr((Date)cis.getStartedAt()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseCompletedAt(DateUtils.getDateTimeStr((Date)cis.getCompletedAt()));
        ((CaseDetailsPresenter.CaseDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseOwner(cis.getOwner());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)2))).getCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
    }
}

