/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.list;

import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.cm.client.events.CaseCancelEvent;
import org.jbpm.console.ng.cm.client.events.CaseDestroyEvent;
import org.jbpm.console.ng.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.menu.ServerTemplateSelectorMenuBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class CaseInstanceListPresenterTest {
    @Mock
    CaseManagementService caseManagementService;
    Caller<CaseManagementService> caseService;
    @Mock
    ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Mock
    CaseInstanceListPresenter.CaseInstanceListView view;
    @Mock
    ExtendedPagedTable<CaseInstanceSummary> pagedTable;
    @Mock
    EventSourceMock<CaseCancelEvent> caseCancelEvent;
    @Mock
    EventSourceMock<CaseDestroyEvent> caseDestroyEvent;
    @Mock
    PlaceManager placeManager;
    @InjectMocks
    CaseInstanceListPresenter presenter;

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.presenter.setCaseCancelEvent(this.caseCancelEvent);
        this.presenter.setCaseDestroyEvent(this.caseDestroyEvent);
        Mockito.when((Object)this.view.getListGrid()).thenReturn(this.pagedTable);
    }

    @Test
    public void testCancelCaseInstance() {
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate()).thenReturn((Object)"serverTemplateId");
        this.presenter.onOpen();
        CaseInstanceSummary cis = new CaseInstanceSummary("caseId", "description", Integer.valueOf(0), "containerId");
        this.presenter.cancelCaseInstance(cis);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).cancelCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseCancelEvent.class);
        ((EventSourceMock)Mockito.verify(this.caseCancelEvent)).fire(captor.capture());
        Assert.assertEquals((Object)cis.getCaseId(), (Object)((CaseCancelEvent)captor.getValue()).getCaseId());
        ((ExtendedPagedTable)Mockito.verify(this.pagedTable)).setVisibleRangeAndClearData((Range)Mockito.any(Range.class), Mockito.anyBoolean());
    }

    @Test
    public void testDestroyCaseInstance() {
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate()).thenReturn((Object)"serverTemplateId");
        this.presenter.onOpen();
        CaseInstanceSummary cis = new CaseInstanceSummary("caseId", "description", Integer.valueOf(0), "containerId");
        this.presenter.destroyCaseInstance(cis);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).destroyCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseDestroyEvent.class);
        ((EventSourceMock)Mockito.verify(this.caseDestroyEvent)).fire(captor.capture());
        Assert.assertEquals((Object)cis.getCaseId(), (Object)((CaseDestroyEvent)captor.getValue()).getCaseId());
        ((ExtendedPagedTable)Mockito.verify(this.pagedTable)).setVisibleRangeAndClearData((Range)Mockito.any(Range.class), Mockito.anyBoolean());
    }

    @Test
    public void testGetData() {
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate()).thenReturn((Object)"serverTemplateId");
        this.presenter.onOpen();
        CaseInstanceSummary cis = new CaseInstanceSummary("caseId", "description", Integer.valueOf(0), "containerId");
        Mockito.when((Object)this.caseManagementService.getCaseInstances("serverTemplateId", Integer.valueOf(0), Integer.valueOf(10))).thenReturn(Arrays.asList(cis));
        Range range = new Range(0, 10);
        this.presenter.getData(range);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstances("serverTemplateId", Integer.valueOf(0), Integer.valueOf(10));
        ((CaseInstanceListPresenter.CaseInstanceListView)Mockito.verify((Object)this.view)).hideBusyIndicator();
    }

    @Test
    public void testSelectCaseInstance() {
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getSelectedServerTemplate()).thenReturn((Object)"serverTemplateId");
        this.presenter.onOpen();
        CaseInstanceSummary cis = new CaseInstanceSummary("caseId", "description", Integer.valueOf(0), "containerId");
        this.presenter.selectCaseInstance(cis);
        ArgumentCaptor captor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        DefaultPlaceRequest dpr = (DefaultPlaceRequest)captor.getValue();
        Assert.assertNotNull((Object)dpr);
        Assert.assertEquals((Object)"serverTemplateId", (Object)dpr.getParameter("serverTemplateId", null));
        Assert.assertEquals((Object)cis.getContainerId(), (Object)dpr.getParameter("containerId", null));
        Assert.assertEquals((Object)cis.getCaseId(), (Object)dpr.getParameter("caseId", null));
    }
}

