/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.roles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jbpm.console.ng.cm.client.AbstractCaseInstancePresenterTest;
import org.jbpm.console.ng.cm.client.roles.CaseRolesPresenter;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock
    CaseRolesPresenter.CaseRolesView caseRolesView;
    @Mock
    CaseRolesPresenter.NewRoleAssignmentView assignmentView;
    @InjectMocks
    CaseRolesPresenter presenter;

    public CaseRolesPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testClearCaseInstance() {
        this.presenter.clearCaseInstance();
        this.verifyClearCaseInstance();
    }

    private void verifyClearCaseInstance() {
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).removeAllRoles();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).disableNewRoleAssignments();
    }

    @Test
    public void testLoadCaseInstance() {
        String serverTemplateId = "serverTemplateId";
        CaseInstanceSummary cis = CaseRolesPresenterTest.newCaseInstanceSummary();
        String roleName = "role";
        String groupName = "group";
        String userName = "user";
        CaseRoleAssignmentSummary cras = new CaseRoleAssignmentSummary("role", Collections.singletonList("group"), Collections.singletonList("user"));
        cis.setRoleAssignments(Collections.singletonList(cras));
        CaseDefinitionSummary cds = new CaseDefinitionSummary();
        cds.setRoles(Collections.singletonMap("role", 3));
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", cis.getContainerId(), cis.getCaseDefinitionId())).thenReturn((Object)cds);
        this.setupCaseInstance(cis, "serverTemplateId");
        this.verifyClearCaseInstance();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).addUser(cis.getOwner(), "Owner", new CaseRolesPresenter.CaseRoleAction[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).addUser((String)Matchers.eq((Object)"user"), (String)Matchers.eq((Object)"role"), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).addGroup((String)Matchers.eq((Object)"group"), (String)Matchers.eq((Object)"role"), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).enableNewRoleAssignments();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).setUserAddCommand((Command)Matchers.any(Command.class));
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).setGroupAddCommand((Command)Matchers.any(Command.class));
    }

    @Test
    public void testSetupRoleAssignmentsEmpty() {
        this.presenter.setupRoleAssignments(new CaseInstanceSummary());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView, (VerificationMode)Mockito.never())).addUser(Matchers.anyString(), Matchers.anyString(), new CaseRolesPresenter.CaseRoleAction[0]);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView, (VerificationMode)Mockito.never())).addGroup(Matchers.anyString(), Matchers.anyString(), new CaseRolesPresenter.CaseRoleAction[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.caseRolesView});
    }

    @Test
    public void testSetupRoleAssignmentsUser() {
        String roleName = "role";
        String userName = "user";
        CaseInstanceSummary cis = new CaseInstanceSummary();
        CaseRoleAssignmentSummary cras = new CaseRoleAssignmentSummary("role", Collections.emptyList(), Collections.singletonList("user"));
        cis.setRoleAssignments(Collections.singletonList(cras));
        this.presenter.setupRoleAssignments(cis);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).addUser((String)Matchers.eq((Object)"user"), (String)Matchers.eq((Object)"role"), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView, (VerificationMode)Mockito.never())).addGroup(Matchers.anyString(), Matchers.anyString(), new CaseRolesPresenter.CaseRoleAction[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.caseRolesView});
        ((CaseRolesPresenter.CaseRoleAction)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"role"), (String)Matchers.eq((Object)"user"));
    }

    @Test
    public void testSetupRoleAssignmentsGroup() {
        String roleName = "role";
        String groupName = "group";
        CaseInstanceSummary cis = new CaseInstanceSummary();
        CaseRoleAssignmentSummary cras = new CaseRoleAssignmentSummary("role", Collections.singletonList("group"), Collections.emptyList());
        cis.setRoleAssignments(Collections.singletonList(cras));
        this.presenter.setupRoleAssignments(cis);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).addGroup((String)Matchers.eq((Object)"group"), (String)Matchers.eq((Object)"role"), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView, (VerificationMode)Mockito.never())).addUser(Matchers.anyString(), Matchers.anyString(), new CaseRolesPresenter.CaseRoleAction[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.caseRolesView});
        ((CaseRolesPresenter.CaseRoleAction)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"role"), (String)Matchers.eq((Object)"group"));
    }

    @Test
    public void testSetupNewRoleAssignmentsEmpty() {
        String caseDefinitionId = "org.jbpm.case";
        CaseDefinitionSummary cds = new CaseDefinitionSummary();
        cds.setRoles(Collections.emptyMap());
        cds.setCaseDefinitionId("org.jbpm.case");
        CaseInstanceSummary cis = new CaseInstanceSummary();
        cis.setCaseDefinitionId(cds.getCaseDefinitionId());
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"org.jbpm.case"))).thenReturn((Object)cds);
        this.presenter.setupNewRoleAssignments(cis);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView, (VerificationMode)Mockito.never())).enableNewRoleAssignments();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.caseRolesView});
    }

    @Test
    public void testSetupNewRoleAssignments() {
        String caseDefinitionId = "org.jbpm.case";
        String roleName = "role";
        CaseDefinitionSummary cds = new CaseDefinitionSummary();
        cds.setCaseDefinitionId("org.jbpm.case");
        cds.setRoles(Collections.singletonMap("role", 1));
        CaseInstanceSummary cis = new CaseInstanceSummary();
        cis.setCaseDefinitionId(cds.getCaseDefinitionId());
        cis.setRoleAssignments(Collections.emptyList());
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)"org.jbpm.case"))).thenReturn((Object)cds);
        this.presenter.setupNewRoleAssignments(cis);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).enableNewRoleAssignments();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Command.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).setUserAddCommand((Command)captor.capture());
        ((Command)captor.getValue()).execute();
        ArgumentCaptor okCommandCaptor = ArgumentCaptor.forClass(Command.class);
        ((CaseRolesPresenter.NewRoleAssignmentView)Mockito.verify((Object)this.assignmentView)).show(Boolean.valueOf(Matchers.eq((boolean)true)), (Set)Matchers.eq(Collections.singleton("role")), (Command)okCommandCaptor.capture());
        ((Command)okCommandCaptor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.caseRolesView)).setGroupAddCommand((Command)captor.capture());
        ((Command)captor.getValue()).execute();
        ((CaseRolesPresenter.NewRoleAssignmentView)Mockito.verify((Object)this.assignmentView)).show(Boolean.valueOf(Matchers.eq((boolean)false)), (Set)Matchers.eq(Collections.singleton("role")), (Command)okCommandCaptor.capture());
        ((Command)okCommandCaptor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testGetRolesAvailableForAssignment() {
        String roleUnlimited = "roleUnlimited";
        String roleFull = "roleFull";
        String roleAvailable = "roleAvailable";
        CaseDefinitionSummary cds = new CaseDefinitionSummary();
        HashMap<String, Integer> roles = new HashMap<String, Integer>();
        roles.put("roleUnlimited", -1);
        roles.put("roleFull", 2);
        roles.put("roleAvailable", 2);
        cds.setRoles(roles);
        CaseInstanceSummary cis = new CaseInstanceSummary();
        cis.setCaseDefinitionId(cds.getCaseDefinitionId());
        ArrayList<CaseRoleAssignmentSummary> roleAssignments = new ArrayList<CaseRoleAssignmentSummary>();
        roleAssignments.add(new CaseRoleAssignmentSummary("roleUnlimited", Collections.singletonList("group"), Collections.singletonList("user")));
        roleAssignments.add(new CaseRoleAssignmentSummary("roleFull", Collections.singletonList("group"), Collections.singletonList("user")));
        roleAssignments.add(new CaseRoleAssignmentSummary("roleAvailable", Collections.emptyList(), Collections.singletonList("user")));
        cis.setRoleAssignments(roleAssignments);
        Set availableRoles = this.presenter.getRolesAvailableForAssignment(cis, cds);
        Assert.assertTrue((boolean)availableRoles.contains("roleUnlimited"));
        Assert.assertFalse((boolean)availableRoles.contains("roleFull"));
        Assert.assertTrue((boolean)availableRoles.contains("roleAvailable"));
    }
}

