/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.details;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.console.ng.cm.client.AbstractCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;

@Dependent
@WorkbenchScreen(identifier="Case Details Screen")
public class CaseDetailsPresenter
extends AbstractCaseInstancePresenter {
    public static final String SCREEN_ID = "Case Details Screen";
    @Inject
    private CaseDetailsView view;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CaseDetails", new Object[0]);
    }

    @WorkbenchPartView
    public UberView<CaseDetailsPresenter> getView() {
        return this.view;
    }

    @Override
    protected void clearCaseInstance() {
        this.view.setCaseId("");
        this.view.setCaseStatus("");
        this.view.setCaseDescription("");
        this.view.setCaseStartedAt("");
        this.view.setCaseCompletedAt("");
        this.view.setCaseOwner("");
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.view.setCaseId(cis.getCaseId());
        this.view.setCaseStatus(this.translationService.format(cis.getStatusString(), new Object[0]));
        this.view.setCaseDescription(cis.getDescription());
        this.view.setCaseStartedAt(DateUtils.getDateTimeStr((Date)cis.getStartedAt()));
        this.view.setCaseCompletedAt(DateUtils.getDateTimeStr((Date)cis.getCompletedAt()));
        this.view.setCaseOwner(cis.getOwner());
    }

    public static interface CaseDetailsView
    extends UberView<CaseDetailsPresenter> {
        public void setCaseDescription(String var1);

        public void setCaseStatus(String var1);

        public void setCaseId(String var1);

        public void setCaseStartedAt(String var1);

        public void setCaseCompletedAt(String var1);

        public void setCaseOwner(String var1);
    }
}

