/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.list;

import com.google.gwt.view.client.Range;
import java.util.HashMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.events.CaseCancelEvent;
import org.jbpm.console.ng.cm.client.events.CaseCreatedEvent;
import org.jbpm.console.ng.cm.client.events.CaseDestroyEvent;
import org.jbpm.console.ng.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.jbpm.console.ng.ga.model.PortableQueryFilter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.list.base.AbstractScreenListPresenter;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.ext.widgets.common.client.menu.RefreshSelectorMenuBuilder;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.paging.PageResponse;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Case List")
public class CaseInstanceListPresenter
extends AbstractScreenListPresenter<CaseInstanceSummary> {
    public static final String SCREEN_ID = "Case List";
    @Inject
    private CaseInstanceListView view;
    private Caller<CaseManagementService> caseService;
    private Event<CaseCancelEvent> caseCancelEvent;
    private Event<CaseDestroyEvent> caseDestroyEvent;
    @Inject
    private TranslationService translationService;
    @Inject
    private NewCaseInstancePresenter newCaseInstancePresenter;

    protected AbstractListView.ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", "", false);
        }
        this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
        this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        ((CaseManagementService)this.caseService.call(cases -> {
            PageResponse response = new PageResponse();
            response.setStartRowIndex(this.currentFilter.getOffset().intValue());
            response.setTotalRowSize(cases.size());
            response.setPageRowList(cases);
            response.setTotalRowSizeExact(cases.isEmpty());
            if (cases.size() < visibleRange.getLength()) {
                response.setLastPage(true);
            } else {
                response.setLastPage(false);
            }
            this.updateDataOnCallback(response);
        })).getCaseInstances(this.selectedServerTemplate, Integer.valueOf(this.currentFilter.getOffset() / this.currentFilter.getCount()), this.currentFilter.getCount());
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CasesList", new Object[0]);
    }

    @WorkbenchPartView
    public UberView<CaseInstanceListPresenter> getView() {
        return this.view;
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.translationService.format("NewCaseInstance", new Object[0])).respondsWith(() -> {
            if (this.selectedServerTemplate != null && !this.selectedServerTemplate.isEmpty()) {
                this.newCaseInstancePresenter.show(this.selectedServerTemplate);
            } else {
                this.view.displayNotification(this.translationService.format("SelectServerTemplate", new Object[0]));
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshSelectorMenuBuilder((RefreshSelectorMenuBuilder.SupportsRefreshInterval)this)).endMenu()).build();
    }

    protected void selectCaseInstance(CaseInstanceSummary cis) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverTemplateId", this.selectedServerTemplate);
        parameters.put("containerId", cis.getContainerId());
        parameters.put("caseId", cis.getCaseId());
        DefaultPlaceRequest overview = new DefaultPlaceRequest("Case Overview Perspective", parameters);
        this.placeManager.goTo((PlaceRequest)overview);
    }

    protected void cancelCaseInstance(CaseInstanceSummary caseInstanceSummary) {
        ((CaseManagementService)this.caseService.call(e -> this.caseCancelEvent.fire((Object)new CaseCancelEvent(caseInstanceSummary.getCaseId())))).cancelCaseInstance(this.selectedServerTemplate, caseInstanceSummary.getContainerId(), caseInstanceSummary.getCaseId());
    }

    protected void destroyCaseInstance(CaseInstanceSummary caseInstanceSummary) {
        ((CaseManagementService)this.caseService.call(e -> this.caseDestroyEvent.fire((Object)new CaseDestroyEvent(caseInstanceSummary.getCaseId())))).destroyCaseInstance(this.selectedServerTemplate, caseInstanceSummary.getContainerId(), caseInstanceSummary.getCaseId());
    }

    public void onCaseCreatedEvent(@Observes CaseCreatedEvent event) {
        this.refreshGrid();
    }

    public void onCaseDestroyEvent(@Observes CaseDestroyEvent event) {
        this.refreshGrid();
    }

    public void onCaseCancelEvent(@Observes CaseCancelEvent event) {
        this.refreshGrid();
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }

    @Inject
    public void setCaseCancelEvent(Event<CaseCancelEvent> caseCancelEvent) {
        this.caseCancelEvent = caseCancelEvent;
    }

    @Inject
    public void setCaseDestroyEvent(Event<CaseDestroyEvent> caseDestroyEvent) {
        this.caseDestroyEvent = caseDestroyEvent;
    }

    public static interface CaseInstanceListView
    extends AbstractListView.ListView<CaseInstanceSummary, CaseInstanceListPresenter> {
    }
}

