/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.gc.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.jbpm.console.ng.gc.client.util.ButtonActionCell;
import org.jbpm.console.ng.gc.client.util.DateUtils;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
public class CaseInstanceListViewImpl
extends AbstractListView<CaseInstanceSummary, CaseInstanceListPresenter>
implements CaseInstanceListPresenter.CaseInstanceListView {
    public static final String COL_ID_CASE_ID = "caseId";
    public static final String COL_ID_DESCRIPTION = "description";
    public static final String COL_ID_OWNER = "owner";
    public static final String COL_ID_STARTED_AT = "startedAt";
    public static final String COL_ID_STATUS = "status";
    public static final String COL_ID_ACTIONS = "Actions";
    public static final String CASE_INSTANCE_LIST_GRID = "CaseInstanceListGrid";
    @Inject
    private TranslationService translationService;

    public void init(CaseInstanceListPresenter presenter) {
        List<String> bannedColumns = Arrays.asList(COL_ID_CASE_ID, COL_ID_ACTIONS);
        List<String> initColumns = Arrays.asList(COL_ID_CASE_ID, COL_ID_DESCRIPTION, COL_ID_STATUS, COL_ID_OWNER, COL_ID_STARTED_AT, COL_ID_ACTIONS);
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(CASE_INSTANCE_LIST_GRID, initColumns, bannedColumns));
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(e -> {
            if (this.selectedRow == -1) {
                this.selectedRow = this.listGrid.getKeyboardSelectedRow();
                this.listGrid.setRowStyles(this.selectedStyles);
                this.listGrid.redraw();
            } else if (this.listGrid.getKeyboardSelectedRow() != this.selectedRow) {
                this.listGrid.setRowStyles(this.selectedStyles);
                this.selectedRow = this.listGrid.getKeyboardSelectedRow();
                this.listGrid.redraw();
            }
            presenter.selectCaseInstance((CaseInstanceSummary)this.selectionModel.getLastSelectedObject());
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<CaseInstanceSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<CaseInstanceSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<CaseInstanceSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && CaseInstanceListViewImpl.this.listGrid.getColumnIndex(CaseInstanceListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        this.listGrid.setEmptyTableCaption(this.translationService.format("NoCasesFound", new Object[0]));
        this.listGrid.setRowStyles(this.selectedStyles);
        this.listGrid.getElement().getStyle().setPaddingRight(20.0, Style.Unit.PX);
        this.listGrid.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
    }

    public void initColumns(ExtendedPagedTable<CaseInstanceSummary> table) {
        this.initCellPreview();
        Column idColumn = this.initIdColumn();
        Column descriptionColumn = this.initDescriptionColumn();
        Column statusColumn = this.initStatusColumn();
        Column ownerColumn = this.initOwnerColumn();
        Column startedAtColumn = this.initStartedAtColumn();
        this.actionsColumn = this.initActionsColumn();
        table.addColumns(Arrays.asList(new ColumnMeta(idColumn, this.translationService.format("Id", new Object[0])), new ColumnMeta(descriptionColumn, this.translationService.format("Description", new Object[0])), new ColumnMeta(statusColumn, this.translationService.format("Status", new Object[0])), new ColumnMeta(ownerColumn, this.translationService.format("Owner", new Object[0])), new ColumnMeta(startedAtColumn, this.translationService.format("StartedAt", new Object[0])), new ColumnMeta(this.actionsColumn, this.translationService.format(COL_ID_ACTIONS, new Object[0]))));
    }

    private void initCellPreview() {
        this.listGrid.addCellPreviewHandler(event -> {
            if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                this.onMouseOverGrid((CellPreviewEvent<CaseInstanceSummary>)event);
            }
        });
    }

    private void onMouseOverGrid(CellPreviewEvent<CaseInstanceSummary> event) {
        CaseInstanceSummary caseInstance = (CaseInstanceSummary)event.getValue();
        if (caseInstance.getDescription() != null) {
            this.listGrid.setTooltip(this.listGrid.getKeyboardSelectedRow(), event.getColumn(), caseInstance.getDescription());
        }
    }

    private Column initIdColumn() {
        Column<CaseInstanceSummary, String> caseIdColumn = new Column<CaseInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(CaseInstanceSummary cis) {
                return cis.getCaseId();
            }
        };
        caseIdColumn.setSortable(true);
        caseIdColumn.setDataStoreName(COL_ID_CASE_ID);
        return caseIdColumn;
    }

    private Column initDescriptionColumn() {
        Column<CaseInstanceSummary, String> descriptionColumn = new Column<CaseInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(CaseInstanceSummary cis) {
                return cis.getDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName(COL_ID_DESCRIPTION);
        return descriptionColumn;
    }

    private Column initOwnerColumn() {
        Column<CaseInstanceSummary, String> ownerColumn = new Column<CaseInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(CaseInstanceSummary cis) {
                return cis.getOwner();
            }
        };
        ownerColumn.setSortable(true);
        ownerColumn.setDataStoreName(COL_ID_OWNER);
        return ownerColumn;
    }

    private Column initStartedAtColumn() {
        Column<CaseInstanceSummary, String> startedAtColumn = new Column<CaseInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(CaseInstanceSummary cis) {
                return DateUtils.getDateTimeStr((Date)cis.getStartedAt());
            }
        };
        startedAtColumn.setSortable(true);
        startedAtColumn.setDataStoreName(COL_ID_STARTED_AT);
        return startedAtColumn;
    }

    private Column initStatusColumn() {
        Column<CaseInstanceSummary, String> statusColumn = new Column<CaseInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(CaseInstanceSummary cis) {
                return CaseInstanceListViewImpl.this.translationService.format(cis.getStatusString(), new Object[0]);
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName(COL_ID_STATUS);
        return statusColumn;
    }

    private Column initActionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new CancelActionHasCell(this.translationService.format("Complete", new Object[0]), (ActionCell.Delegate<CaseInstanceSummary>)((ActionCell.Delegate)caseInstanceSummary -> ((CaseInstanceListPresenter)this.presenter).cancelCaseInstance((CaseInstanceSummary)caseInstanceSummary))));
        cells.add(new DestroyActionHasCell(this.translationService.format("Close", new Object[0]), (ActionCell.Delegate<CaseInstanceSummary>)((ActionCell.Delegate)caseInstanceSummary -> ((CaseInstanceListPresenter)this.presenter).destroyCaseInstance((CaseInstanceSummary)caseInstanceSummary))));
        CompositeCell cell = new CompositeCell(cells);
        Column<CaseInstanceSummary, CaseInstanceSummary> actionsColumn = new Column<CaseInstanceSummary, CaseInstanceSummary>((Cell)cell){

            public CaseInstanceSummary getValue(CaseInstanceSummary caseInstanceSummary) {
                return caseInstanceSummary;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    protected class DestroyActionHasCell
    extends ButtonActionCell<CaseInstanceSummary> {
        public DestroyActionHasCell(String text, ActionCell.Delegate<CaseInstanceSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, CaseInstanceSummary caseInstanceSummary, SafeHtmlBuilder sb) {
            if (caseInstanceSummary.isActive().booleanValue()) {
                super.render(context, (Object)caseInstanceSummary, sb);
            }
        }
    }

    protected class CancelActionHasCell
    extends ButtonActionCell<CaseInstanceSummary> {
        public CancelActionHasCell(String text, ActionCell.Delegate<CaseInstanceSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, CaseInstanceSummary caseInstanceSummary, SafeHtmlBuilder sb) {
            if (caseInstanceSummary.isActive().booleanValue()) {
                super.render(context, (Object)caseInstanceSummary, sb);
            }
        }
    }
}

