/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.newcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.events.CaseCreatedEvent;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewCaseInstancePresenter {
    private final Map<String, CaseDefinitionSummary> caseDefinitions = new HashMap<String, CaseDefinitionSummary>();
    @Inject
    private NewCaseInstanceView view;
    private Caller<CaseManagementService> caseService;
    private Event<NotificationEvent> notification;
    private Event<CaseCreatedEvent> newCaseEvent;
    @Inject
    private TranslationService translationService;
    private String serverTemplateId;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void show(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
        this.loadCaseDefinitions();
    }

    protected void loadCaseDefinitions() {
        this.view.clearCaseDefinitions();
        this.caseDefinitions.clear();
        ((CaseManagementService)this.caseService.call(definitions -> {
            ArrayList<String> definitionNames = new ArrayList<String>();
            for (CaseDefinitionSummary summary : definitions) {
                definitionNames.add(summary.getName());
                this.caseDefinitions.put(summary.getName(), summary);
            }
            Collections.sort(definitionNames);
            this.view.addCaseDefinitions(definitionNames);
            this.view.show();
        })).getCaseDefinitions(this.serverTemplateId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
    }

    protected void createCaseInstance(String caseDefinitionName) {
        CaseDefinitionSummary caseDefinition = this.caseDefinitions.get(caseDefinitionName);
        if (caseDefinition == null) {
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("InvalidCaseDefinition", new Object[0]), NotificationEvent.NotificationType.ERROR));
            return;
        }
        ((CaseManagementService)this.caseService.call(caseId -> {
            this.view.hide();
            this.notification.fire((Object)new NotificationEvent(this.translationService.format("CaseCreatedWithId", new Object[]{caseId}), NotificationEvent.NotificationType.SUCCESS));
            this.newCaseEvent.fire((Object)new CaseCreatedEvent((String)caseId));
        })).startCaseInstance(this.serverTemplateId, caseDefinition.getContainerId(), caseDefinition.getCaseDefinitionId());
    }

    @Inject
    public void setNotification(Event<NotificationEvent> notification) {
        this.notification = notification;
    }

    @Inject
    public void setNewCaseEvent(Event<CaseCreatedEvent> newCaseEvent) {
        this.newCaseEvent = newCaseEvent;
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }

    public static interface NewCaseInstanceView
    extends UberView<NewCaseInstancePresenter> {
        public void show();

        public void hide();

        public void clearCaseDefinitions();

        public void addCaseDefinitions(List<String> var1);
    }
}

