/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.newcase;

import com.google.common.base.Strings;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.newcase.NewCaseInstancePresenter;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;

@Dependent
@Templated
public class NewCaseInstanceViewImpl
extends Composite
implements NewCaseInstancePresenter.NewCaseInstanceView {
    private final BaseModal modal = (BaseModal)GWT.create(BaseModal.class);
    @DataField(value="definition-name-group")
    Element caseDefinitionNameGroup = DOM.createDiv();
    @Inject
    @DataField(value="definition-name-help")
    Span definitionNameHelp;
    @DataField(value="definition-name-select")
    Select caseTemplatesList = (Select)GWT.create(Select.class);
    @Inject
    @DataField(value="definition-name-label")
    FormLabel caseDefinitionNameLabel;
    @Inject
    private TranslationService translationService;
    private NewCaseInstancePresenter presenter;

    public void init(NewCaseInstancePresenter presenter) {
        this.presenter = presenter;
        this.modal.setTitle(this.translationService.format("NewCaseInstance", new Object[0]));
        this.modal.setBody((Widget)this);
        GenericModalFooter footer = (GenericModalFooter)GWT.create(GenericModalFooter.class);
        footer.addButton(this.translationService.format("Create", new Object[0]), () -> this.okButton(), IconType.PLUS, ButtonType.PRIMARY);
        this.modal.add((Widget)footer);
        this.caseDefinitionNameLabel.setShowRequiredIndicator(true);
    }

    @Override
    public void show() {
        this.cleanForm();
        this.modal.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createCaseInstance();
        }
    }

    @Override
    public void clearCaseDefinitions() {
        this.caseTemplatesList.clear();
    }

    @Override
    public void addCaseDefinitions(List<String> definitions) {
        for (String definition : definitions) {
            Option option = (Option)GWT.create(Option.class);
            option.setText(definition);
            option.setValue(definition);
            this.caseTemplatesList.add((Widget)option);
        }
        this.caseTemplatesList.refresh();
    }

    public void cleanForm() {
        this.caseTemplatesList.setValue((Object)"");
        this.caseTemplatesList.setFocus(true);
        this.clearErrorMessages();
    }

    @Override
    public void hide() {
        this.cleanForm();
        this.modal.hide();
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        if (Strings.isNullOrEmpty((String)this.caseTemplatesList.getValue())) {
            this.caseTemplatesList.setFocus(true);
            this.definitionNameHelp.setTextContent(this.translationService.format("PleaseSelectCaseDefinition", new Object[0]));
            this.setCaseDefinitionNameGroupStyle(ValidationState.ERROR);
            return false;
        }
        this.setCaseDefinitionNameGroupStyle(ValidationState.SUCCESS);
        return true;
    }

    private void setCaseDefinitionNameGroupStyle(ValidationState error) {
        StyleHelper.addUniqueEnumStyleName((Element)this.caseDefinitionNameGroup, ValidationState.class, (Style.HasCssName)error);
    }

    private void createCaseInstance() {
        this.presenter.createCaseInstance(this.caseTemplatesList.getValue());
    }

    private void clearErrorMessages() {
        this.definitionNameHelp.setTextContent("");
        this.setCaseDefinitionNameGroupStyle(ValidationState.NONE);
    }
}

