/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.roles;

import com.google.common.base.Strings;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.roles.CaseRolesPresenter;
import org.uberfire.ext.widgets.common.client.common.StyleHelper;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class NewRoleAssignmentViewImpl
extends Composite
implements CaseRolesPresenter.NewRoleAssignmentView {
    @DataField(value="role-name-group")
    Element roleNameGroup = DOM.createDiv();
    @Inject
    @DataField(value="role-name-help")
    Span roleNameHelp;
    @DataField(value="role-name-select")
    Select roleNameList = (Select)GWT.create(Select.class);
    @Inject
    @DataField(value="role-name-label")
    FormLabel roleNameLabel;
    @Inject
    @DataField(value="user-name-label")
    FormLabel userNameLabel;
    @Inject
    @DataField(value="user-name-input")
    TextInput userNameInput;
    @Inject
    @DataField(value="user-name-help")
    Span userNameHelp;
    @DataField(value="user-name-group")
    Element userNameGroup = DOM.createDiv();
    private BaseModal modal = (BaseModal)GWT.create(BaseModal.class);
    private Boolean forUser;
    private Command okCommand;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.modal.setTitle(this.translationService.format("NewRoleAssignment", new Object[0]));
        this.modal.setBody((Widget)this);
        GenericModalFooter footer = (GenericModalFooter)GWT.create(GenericModalFooter.class);
        footer.addButton(this.translationService.format("Assign", new Object[0]), () -> this.okButton(), IconType.PLUS, ButtonType.PRIMARY);
        this.modal.add((Widget)footer);
        this.roleNameLabel.setShowRequiredIndicator(true);
        this.userNameLabel.setShowRequiredIndicator(true);
    }

    public void init(CaseRolesPresenter presenter) {
    }

    @Override
    public void show(Boolean forUser, Set<String> roles, Command okCommand) {
        this.clearErrorMessages();
        this.clearValues();
        this.forUser = forUser;
        this.userNameLabel.setText(this.translationService.format(forUser != false ? "User" : "Group", new Object[0]));
        for (String role : roles) {
            Option option = (Option)GWT.create(Option.class);
            option.setValue(role);
            option.setText(role);
            this.roleNameList.add((Widget)option);
        }
        this.roleNameList.refresh();
        this.okCommand = okCommand;
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    private void okButton() {
        if (!this.validateForm()) {
            return;
        }
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    private boolean validateForm() {
        boolean userNameEmpty;
        this.clearErrorMessages();
        boolean roleNameEmpty = Strings.isNullOrEmpty((String)this.roleNameList.getValue());
        if (roleNameEmpty) {
            this.roleNameList.setFocus(true);
            this.roleNameHelp.setTextContent(this.translationService.format("PleaseSelectRole", new Object[0]));
            this.setFormGroupStyle(this.roleNameGroup, ValidationState.ERROR);
        }
        if (userNameEmpty = Strings.isNullOrEmpty((String)this.userNameInput.getValue())) {
            this.userNameInput.focus();
            this.userNameHelp.setTextContent(this.translationService.format(this.forUser != false ? "UserRequired" : "GroupRequired", new Object[0]));
            this.setFormGroupStyle(this.userNameGroup, ValidationState.ERROR);
        }
        if (roleNameEmpty || userNameEmpty) {
            return false;
        }
        this.setFormGroupStyle(this.roleNameGroup, ValidationState.SUCCESS);
        this.setFormGroupStyle(this.userNameGroup, ValidationState.SUCCESS);
        return true;
    }

    private void clearValues() {
        this.roleNameList.setValue((Object)"");
        this.roleNameList.clear();
        this.roleNameList.refresh();
        this.userNameInput.setValue("");
    }

    private void clearErrorMessages() {
        this.roleNameHelp.setTextContent("");
        this.userNameHelp.setTextContent("");
        this.setFormGroupStyle(this.userNameGroup, ValidationState.NONE);
        this.setFormGroupStyle(this.roleNameGroup, ValidationState.NONE);
    }

    private void setFormGroupStyle(Element element, ValidationState validationState) {
        StyleHelper.addUniqueEnumStyleName((Element)element, ValidationState.class, (Style.HasCssName)validationState);
    }

    @Override
    public String getRoleName() {
        return this.roleNameList.getValue();
    }

    @Override
    public String getUserName() {
        return this.userNameInput.getValue();
    }
}

