/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.overview;

import org.jbpm.console.ng.cm.client.events.CaseCancelEvent;
import org.jbpm.console.ng.cm.client.events.CaseDestroyEvent;
import org.jbpm.console.ng.cm.client.events.CaseRefreshEvent;
import org.jbpm.console.ng.cm.client.overview.CaseOverviewPresenter;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseOverviewPresenterTest
extends AbstractCaseInstancePresenterTest {
    private final String serverTemplateId = "serverTemplateId";
    @Mock
    CaseOverviewPresenter.CaseOverviewView view;
    @Mock
    PlaceManager placeManager;
    @Mock
    EventSourceMock<CaseCancelEvent> caseCancelEvent;
    @Mock
    EventSourceMock<CaseDestroyEvent> caseDestroyEvent;
    @Mock
    EventSourceMock<CaseRefreshEvent> caseRefreshEvent;
    @InjectMocks
    CaseOverviewPresenter presenter;

    @Before
    public void setup() {
        this.presenter.setCaseCancelEvent(this.caseCancelEvent);
        this.presenter.setCaseDestroyEvent(this.caseDestroyEvent);
        this.presenter.setCaseRefreshEvent(this.caseRefreshEvent);
    }

    public CaseOverviewPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((CaseOverviewPresenter.CaseOverviewView)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testReturnToCaseList() {
        this.presenter.backToList();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("Case List Perspective");
    }

    @Test
    public void testFindCaseInstance() {
        this.presenter.findCaseInstance();
        ((CaseOverviewPresenter.CaseOverviewView)Mockito.verify((Object)this.view)).setCaseId("");
        ((CaseOverviewPresenter.CaseOverviewView)Mockito.verify((Object)this.view)).setCaseTitle("");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.view});
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.never())).getCaseInstance(Mockito.anyString(), Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void testRefreshCase() {
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.refreshCase();
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRefreshEvent.class);
        ((EventSourceMock)Mockito.verify(this.caseRefreshEvent)).fire(captor.capture());
        Assert.assertEquals((Object)cis.getCaseId(), (Object)((CaseRefreshEvent)captor.getValue()).getCaseId());
    }

    @Test
    public void testOnCaseRefreshEvent() {
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.onCaseRefreshEvent(new CaseRefreshEvent(cis.getCaseId()));
        ((CaseOverviewPresenter.CaseOverviewView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseId("");
        ((CaseOverviewPresenter.CaseOverviewView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCaseTitle("");
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService, (VerificationMode)Mockito.times((int)2))).getCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
    }

    @Test
    public void testCancelCaseInstance() {
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.cancelCaseInstance();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).cancelCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseCancelEvent.class);
        ((EventSourceMock)Mockito.verify(this.caseCancelEvent)).fire(captor.capture());
        Assert.assertEquals((Object)cis.getCaseId(), (Object)((CaseCancelEvent)captor.getValue()).getCaseId());
    }

    @Test
    public void testDestroyCaseInstance() {
        CaseInstanceSummary cis = this.setupCaseInstance("serverTemplateId");
        this.presenter.destroyCaseInstance();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).destroyCaseInstance("serverTemplateId", cis.getContainerId(), cis.getCaseId());
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseDestroyEvent.class);
        ((EventSourceMock)Mockito.verify(this.caseDestroyEvent)).fire(captor.capture());
        Assert.assertEquals((Object)cis.getCaseId(), (Object)((CaseDestroyEvent)captor.getValue()).getCaseId());
    }
}

