/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import com.google.common.base.Strings;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.console.ng.cm.client.util.FormGroup;
import org.jbpm.console.ng.cm.client.util.ValidationState;

@Dependent
@Templated
public class CaseCommentItemView
implements IsElement {
    @Inject
    @DataField(value="comment-author")
    Span commentAuthor;
    @Inject
    @DataField(value="comment-text")
    Span commentText;
    @Inject
    @DataField(value="comment-addedat")
    Span commentAddedAt;
    @Inject
    @DataField(value="user-actions")
    Div userActions;
    @Inject
    @DataField(value="list-group-item")
    Div listGroupItem;
    @Inject
    @DataField(value="actions-dropdown")
    Div actions;
    @Inject
    @DataField(value="actions-items")
    UnorderedList actionsItems;
    @Inject
    @DataField(value="comment-update-input")
    TextInput updateCommentText;
    @Inject
    @DataField(value="comment-update-help")
    Span updateCommentTextHelp;
    @Inject
    @DataField(value="comment-update-group")
    FormGroup updateCommentTextGroup;
    @Inject
    @DataField(value="comment-show")
    Div commentShowGroup;
    @Inject
    @DataField(value="comment-update")
    Div commentUpdate;
    @Inject
    private TranslationService translationService;
    CaseCommentsPresenter.CaseCommentAction updateCommandAction;

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public void setCommentAuthor(String commentAutor) {
        this.commentAuthor.setInnerHTML(commentAutor);
    }

    public void setCommentText(String commentText) {
        this.commentText.setTextContent(commentText);
        this.updateCommentText.setValue(commentText);
    }

    public void setCommentAddedAt(String commentAddedAt) {
        this.commentAddedAt.setInnerHTML(commentAddedAt);
    }

    public void addAction(CaseCommentsPresenter.CaseCommentAction action) {
        DOMUtil.removeCSSClass((HTMLElement)this.actions, (String)"hidden");
        HTMLElement a = Window.getDocument().createElement("a");
        a.setTextContent(action.label());
        a.setOnclick(e -> action.execute());
        HTMLElement li = Window.getDocument().createElement("li");
        li.appendChild((Node)a);
        this.actionsItems.appendChild((Node)li);
    }

    public void addUpdateCommentAction(CaseCommentsPresenter.CaseCommentAction action) {
        this.updateCommandAction = action;
        this.addAction(action);
    }

    public String getUpdatedComment() {
        return this.updateCommentText.getValue();
    }

    public void setEditMode(boolean editMode) {
        if (editMode) {
            DOMUtil.addCSSClass((HTMLElement)this.commentShowGroup, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.commentUpdate, (String)"hidden");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.commentUpdate, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.commentShowGroup, (String)"hidden");
        }
    }

    public void clearErrorMessages() {
        this.updateCommentTextHelp.setTextContent("");
        this.updateCommentTextGroup.clearValidationState();
    }

    public boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.updateCommentText.getValue());
        if (newCommentEmpty) {
            this.updateCommentText.focus();
            this.updateCommentTextHelp.setTextContent(this.translationService.format("CommentCannotBeEmpty", new Object[0]));
            this.updateCommentTextGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }

    @EventHandler(value={"comment-update-input"})
    public void updateCommentPressingEnter(@ForEvent(value={"keyup"}) KeyboardEvent e) {
        if ("Enter".equals(e.getKey()) || "Enter".equals(e.getCode()) || "NumpadEnter".equals(e.getCode())) {
            this.updateCommandAction.execute();
        }
    }
}

