/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Comments")
public class CaseCommentsPresenter
extends AbstractCaseInstancePresenter {
    public static final String SCREEN_ID = "Case Comments";
    @Inject
    private CaseCommentsView caseCommentView;
    @Inject
    private TranslationService translationService;
    @Inject
    User identity;
    private String currentUpdatedCommentId = "";

    @WorkbenchPartView
    public UberElement<CaseCommentsPresenter> getView() {
        return this.caseCommentView;
    }

    @WorkbenchPartTitle
    public String getTittle() {
        return this.translationService.format("Comments", new Object[0]);
    }

    @Override
    protected void clearCaseInstance() {
        this.caseCommentView.removeAllComments();
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.refreshComments();
    }

    public void refreshComments() {
        this.clearCaseInstance();
        ((CaseManagementService)this.caseService.call(comments -> {
            boolean editing = false;
            for (final CaseCommentSummary caseCommentSummary : comments) {
                CaseCommentAction deleteCommentAction = null;
                String updateActionLabel = null;
                if (this.identity.getIdentifier().equals(caseCommentSummary.getAuthor())) {
                    if (caseCommentSummary.getId().equals(this.currentUpdatedCommentId)) {
                        editing = true;
                        updateActionLabel = this.translationService.format("Save", new Object[0]);
                    } else {
                        editing = false;
                        updateActionLabel = this.translationService.format("Edit", new Object[0]);
                    }
                    deleteCommentAction = new CaseCommentAction(){

                        @Override
                        public String label() {
                            return CaseCommentsPresenter.this.translationService.format("Delete", new Object[0]);
                        }

                        public void execute() {
                            CaseCommentsPresenter.this.deleteCaseComment(caseCommentSummary.getId());
                        }
                    };
                }
                this.caseCommentView.addComment(editing, updateActionLabel, caseCommentSummary.getId(), caseCommentSummary.getAuthor(), caseCommentSummary.getText(), caseCommentSummary.getAddedAt(), deleteCommentAction);
            }
        })).getComments(this.serverTemplateId, this.containerId, this.caseId);
    }

    protected void addCaseComment(String caseCommentText) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).addComment(this.serverTemplateId, this.containerId, this.caseId, this.identity.getIdentifier(), caseCommentText);
    }

    protected void addCaseComment(CaseCommentSummary caseCommentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).addComment(this.serverTemplateId, this.containerId, this.caseId, caseCommentSummary.getAuthor(), caseCommentSummary.getText());
    }

    protected void updateCaseComment(String caseCommentText, String caseCommentId) {
        this.setCurrentUpdatedCommentId("");
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).updateComment(this.serverTemplateId, this.containerId, this.caseId, caseCommentId, this.identity.getIdentifier(), caseCommentText);
    }

    protected void deleteCaseComment(String caseCommentId) {
        this.setCurrentUpdatedCommentId("");
        ((CaseManagementService)this.caseService.call(Void2 -> this.refreshComments())).removeComment(this.serverTemplateId, this.containerId, this.caseId, caseCommentId);
    }

    public void setCurrentUpdatedCommentId(String commentId) {
        this.currentUpdatedCommentId = commentId;
    }

    public static interface CaseCommentAction
    extends Command {
        public String label();
    }

    public static interface CaseCommentsView
    extends UberElement<CaseCommentsPresenter> {
        public void clearCommentInputForm();

        public void removeAllComments();

        public void addComment(boolean var1, String var2, String var3, String var4, String var5, Date var6, CaseCommentAction ... var7);
    }
}

