/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.comments;

import com.google.common.base.Strings;
import java.util.Date;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.KeyboardEvent;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.comments.CaseCommentItemView;
import org.jbpm.console.ng.cm.client.comments.CaseCommentsPresenter;
import org.jbpm.console.ng.cm.client.util.DateConverter;
import org.jbpm.console.ng.cm.client.util.FormGroup;
import org.jbpm.console.ng.cm.client.util.ValidationState;

@Dependent
@Templated
public class CaseCommentsViewImpl
implements CaseCommentsPresenter.CaseCommentsView {
    @Inject
    @DataField(value="comments")
    Div commentsContainer;
    @Inject
    @DataField(value="comments-list")
    Div comments;
    @Inject
    @DataField(value="comment-creation")
    Div commentCreation;
    @Inject
    @DataField(value="comment-creation-input")
    TextInput newCommentTextArea;
    @Inject
    @DataField(value="comment-creation-label")
    Label newCommentLabel;
    @Inject
    @DataField(value="comment-creation-help")
    Span newCommentTextAreaHelp;
    @Inject
    @DataField(value="comment-creation-group")
    FormGroup newCommentTextAreaGroup;
    @Inject
    @DataField
    Anchor addCommentButton;
    @Inject
    private ManagedInstance<CaseCommentItemView> provider;
    @Inject
    private TranslationService translationService;
    private CaseCommentsPresenter presenter;

    public void init(CaseCommentsPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void removeAllComments() {
        this.clearCommentInputForm();
        DOMUtil.removeAllChildren((Node)this.comments);
    }

    @Override
    public void clearCommentInputForm() {
        this.newCommentTextArea.setValue("");
        this.clearErrorMessages();
    }

    public void clearErrorMessages() {
        this.newCommentTextAreaHelp.setTextContent("");
        this.newCommentTextAreaGroup.clearValidationState();
    }

    @Override
    public void addComment(final boolean editing, String editActionLabel, final String commentId, String author, String commentText, Date commentAddedAt, CaseCommentsPresenter.CaseCommentAction ... actions) {
        final CaseCommentItemView commentItemView = (CaseCommentItemView)this.provider.get();
        commentItemView.setCommentAuthor(author);
        commentItemView.setCommentText(commentText);
        commentItemView.setCommentAddedAt(DateConverter.getDateStr(commentAddedAt));
        commentItemView.setEditMode(editing);
        if (editActionLabel != null) {
            for (CaseCommentsPresenter.CaseCommentAction action : actions) {
                commentItemView.addAction(action);
            }
            if (editing) {
                commentItemView.addUpdateCommentAction(new CaseCommentsPresenter.CaseCommentAction(){

                    @Override
                    public String label() {
                        return CaseCommentsViewImpl.this.translationService.format("Save", new Object[0]);
                    }

                    public void execute() {
                        if (commentItemView.validateForm()) {
                            CaseCommentsViewImpl.this.presenter.updateCaseComment(commentItemView.getUpdatedComment(), commentId);
                            commentItemView.setEditMode(false);
                        }
                    }
                });
            }
            commentItemView.addAction(new CaseCommentsPresenter.CaseCommentAction(){

                @Override
                public String label() {
                    if (editing) {
                        return CaseCommentsViewImpl.this.translationService.format("Cancel", new Object[0]);
                    }
                    return CaseCommentsViewImpl.this.translationService.format("Edit", new Object[0]);
                }

                public void execute() {
                    String cmmntId = "";
                    if (!editing) {
                        cmmntId = commentId;
                    }
                    CaseCommentsViewImpl.this.presenter.setCurrentUpdatedCommentId(cmmntId);
                    commentItemView.setEditMode(!editing);
                    CaseCommentsViewImpl.this.presenter.refreshComments();
                }
            });
        }
        this.comments.appendChild((Node)commentItemView.getElement());
    }

    @EventHandler(value={"addCommentButton"})
    public void addCommentButton(@ForEvent(value={"click"}) Event e) {
        this.submitCommentAddition();
    }

    @EventHandler(value={"comment-creation-input"})
    public void addCommentPressingEnter(@ForEvent(value={"keyup"}) KeyboardEvent e) {
        if ("Enter".equals(e.getKey()) || "Enter".equals(e.getCode()) || "NumpadEnter".equals(e.getCode())) {
            this.submitCommentAddition();
        }
    }

    private void submitCommentAddition() {
        if (this.validateForm()) {
            this.presenter.addCaseComment(this.newCommentTextArea.getValue());
        }
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        boolean newCommentEmpty = Strings.isNullOrEmpty((String)this.newCommentTextArea.getValue());
        if (newCommentEmpty) {
            this.newCommentTextArea.focus();
            this.newCommentTextAreaHelp.setTextContent(this.translationService.format("CommentCannotBeEmpty", new Object[0]));
            this.newCommentTextAreaGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        return true;
    }

    public HTMLElement getElement() {
        return this.commentsContainer;
    }
}

