/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.list;

import com.google.gwt.user.client.TakesValue;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.console.ng.cm.client.util.AbstractView;
import org.jbpm.console.ng.cm.client.util.CaseStatusConverter;
import org.jbpm.console.ng.cm.client.util.CaseStatusEnum;
import org.jbpm.console.ng.cm.client.util.DateConverter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;

@Dependent
@Templated(stylesheet="CaseInstanceViewImpl.css")
public class CaseInstanceViewImpl
extends AbstractView<CaseInstanceListPresenter>
implements TakesValue<CaseInstanceSummary>,
IsElement {
    @Inject
    @DataField(value="list-item")
    private Div row;
    @Inject
    @DataField(value="name")
    @Bound(property="caseId")
    private Span caseId;
    @Inject
    @DataField(value="description")
    @Bound
    private Div description;
    @Inject
    @DataField(value="owner")
    @Bound
    private Span owner;
    @Inject
    @DataField(value="status")
    @Bound(converter=CaseStatusConverter.class)
    private Span status;
    @Inject
    @DataField(value="started")
    @Bound(converter=DateConverter.class)
    private Span startedAt;
    @Inject
    @DataField(value="complete")
    private Button complete;
    @Inject
    @DataField(value="kebab")
    private Div kebab;
    @Inject
    @DataField(value="case-details")
    private Div details;
    @Inject
    @AutoBound
    private DataBinder<CaseInstanceSummary> caseInstanceSummary;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.status);
    }

    public CaseInstanceSummary getValue() {
        return (CaseInstanceSummary)this.caseInstanceSummary.getModel();
    }

    public void setValue(CaseInstanceSummary model) {
        this.caseInstanceSummary.setModel((Object)model);
        this.executeOnlyIfActive(c -> {
            DOMUtil.addCSSClass((HTMLElement)this.details, (String)"active");
            DOMUtil.addCSSClass((HTMLElement)this.status, (String)"label-success");
            DOMUtil.removeCSSClass((HTMLElement)this.status, (String)"label-default");
            DOMUtil.removeCSSClass((HTMLElement)this.complete, (String)"hidden");
            DOMUtil.removeCSSClass((HTMLElement)this.kebab, (String)"hidden");
        });
    }

    public HTMLElement getElement() {
        return this.row;
    }

    @EventHandler(value={"complete"})
    public void onCompleteClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.executeOnlyIfActive(c -> ((CaseInstanceListPresenter)this.presenter).cancelCaseInstance((CaseInstanceSummary)c));
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.executeOnlyIfActive(c -> ((CaseInstanceListPresenter)this.presenter).destroyCaseInstance((CaseInstanceSummary)c));
    }

    @EventHandler(value={"case-details"})
    public void onCaseInstanceClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.executeOnlyIfActive(c -> ((CaseInstanceListPresenter)this.presenter).selectCaseInstance((CaseInstanceSummary)c));
    }

    private void executeOnlyIfActive(Consumer<CaseInstanceSummary> consumer) {
        CaseInstanceSummary caseInstanceSummary = (CaseInstanceSummary)this.caseInstanceSummary.getModel();
        CaseStatusEnum status = CaseStatusEnum.fromStatus(caseInstanceSummary.getStatus());
        if (status == CaseStatusEnum.ACTIVE) {
            consumer.accept(caseInstanceSummary);
        }
    }

    private native void tooltip(HTMLElement var1);
}

