/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.overview;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.events.CaseCancelEvent;
import org.jbpm.console.ng.cm.client.events.CaseDestroyEvent;
import org.jbpm.console.ng.cm.client.events.CaseRefreshEvent;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnOpen;

@Dependent
@WorkbenchScreen(identifier="Case Overview")
public class CaseOverviewPresenter
extends AbstractCaseInstancePresenter {
    public static final String SCREEN_ID = "Case Overview";
    @Inject
    PlaceManager placeManager;
    @Inject
    private CaseOverviewView view;
    @Inject
    private TranslationService translationService;
    private Event<CaseCancelEvent> caseCancelEvent;
    private Event<CaseDestroyEvent> caseDestroyEvent;
    private Event<CaseRefreshEvent> caseRefreshEvent;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @WorkbenchPartView
    public UberElement<CaseOverviewPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CaseOverview", new Object[0]);
    }

    @OnOpen
    public void onOpen() {
        this.view.addCaseDetails("Case Details Screen", this.place.getParameters());
        this.view.addCaseRoles("Case Roles", this.place.getParameters());
        this.view.addCaseComments("Case Comments", this.place.getParameters());
    }

    protected void refreshCase() {
        this.caseRefreshEvent.fire((Object)new CaseRefreshEvent(this.caseId));
    }

    @Override
    protected void clearCaseInstance() {
        this.view.setCaseTitle("");
        this.view.setCaseId("");
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.view.setCaseTitle(cis.getDescription());
        this.view.setCaseId(cis.getCaseId());
    }

    protected void cancelCaseInstance() {
        ((CaseManagementService)this.caseService.call(e -> {
            this.caseCancelEvent.fire((Object)new CaseCancelEvent(this.caseId));
            this.backToList();
        })).cancelCaseInstance(this.serverTemplateId, this.containerId, this.caseId);
    }

    protected void destroyCaseInstance() {
        ((CaseManagementService)this.caseService.call(e -> {
            this.caseDestroyEvent.fire((Object)new CaseDestroyEvent(this.caseId));
            this.backToList();
        })).destroyCaseInstance(this.serverTemplateId, this.containerId, this.caseId);
    }

    protected void backToList() {
        this.placeManager.goTo("Case List Perspective");
    }

    @Inject
    public void setCaseCancelEvent(Event<CaseCancelEvent> caseCancelEvent) {
        this.caseCancelEvent = caseCancelEvent;
    }

    @Inject
    public void setCaseDestroyEvent(Event<CaseDestroyEvent> caseDestroyEvent) {
        this.caseDestroyEvent = caseDestroyEvent;
    }

    @Inject
    public void setCaseRefreshEvent(Event<CaseRefreshEvent> caseRefreshEvent) {
        this.caseRefreshEvent = caseRefreshEvent;
    }

    public static interface CaseOverviewView
    extends UberElement<CaseOverviewPresenter> {
        public void setCaseTitle(String var1);

        public void setCaseId(String var1);

        public void addCaseDetails(String var1, Map<String, String> var2);

        public void addCaseStages(String var1, Map<String, String> var2);

        public void addCaseActions(String var1, Map<String, String> var2);

        public void addCaseComments(String var1, Map<String, String> var2);

        public void addCaseFiles(String var1, Map<String, String> var2);

        public void addCaseRoles(String var1, Map<String, String> var2);

        public void addCaseMilestones(String var1, Map<String, String> var2);

        public void addCaseActivities(String var1, Map<String, String> var2);
    }
}

