/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.roles;

import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Roles")
public class CaseRolesPresenter
extends AbstractCaseInstancePresenter {
    public static final String SCREEN_ID = "Case Roles";
    @Inject
    private CaseRolesView caseRolesView;
    @Inject
    private NewRoleAssignmentView newRoleAssignmentView;
    @Inject
    private TranslationService translationService;

    @WorkbenchPartView
    public UberElement<CaseRolesPresenter> getView() {
        return this.caseRolesView;
    }

    @WorkbenchPartTitle
    public String getTittle() {
        return this.translationService.format("Roles", new Object[0]);
    }

    @Override
    protected void clearCaseInstance() {
        this.caseRolesView.disableNewRoleAssignments();
        this.caseRolesView.removeAllRoles();
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.caseRolesView.addUser(cis.getOwner(), this.translationService.format("Owner", new Object[0]), new CaseRoleAction[0]);
        this.setupRoleAssignments(cis);
        this.setupNewRoleAssignments(cis);
    }

    protected void setupNewRoleAssignments(CaseInstanceSummary cis) {
        ((CaseManagementService)this.caseService.call(cds -> {
            if (cds.getRoles() == null || cds.getRoles().isEmpty()) {
                return;
            }
            Set<String> roles = this.getRolesAvailableForAssignment(cis, (CaseDefinitionSummary)cds);
            if (roles.isEmpty()) {
                return;
            }
            this.caseRolesView.enableNewRoleAssignments();
            this.caseRolesView.setUserAddCommand(() -> this.newRoleAssignmentView.show(true, roles, () -> this.addUserToRole(this.newRoleAssignmentView.getUserName(), this.newRoleAssignmentView.getRoleName())));
            this.caseRolesView.setGroupAddCommand(() -> this.newRoleAssignmentView.show(false, roles, () -> this.addGroupToRole(this.newRoleAssignmentView.getUserName(), this.newRoleAssignmentView.getRoleName())));
        })).getCaseDefinition(this.serverTemplateId, this.containerId, cis.getCaseDefinitionId());
    }

    protected Set<String> getRolesAvailableForAssignment(CaseInstanceSummary cis, CaseDefinitionSummary cds) {
        return cds.getRoles().keySet().stream().filter(role -> {
            if ("owner".equals(role)) {
                return false;
            }
            Integer roleCardinality = (Integer)cds.getRoles().get(role);
            if (roleCardinality == -1) {
                return true;
            }
            Integer roleInstanceCardinality = cis.getRoleAssignments().stream().filter(ra -> role.equals(ra.getName())).findFirst().map(ra -> ra.getGroups().size() + ra.getUsers().size()).orElse(0);
            return roleInstanceCardinality < roleCardinality;
        }).collect(Collectors.toSet());
    }

    protected void setupRoleAssignments(CaseInstanceSummary cis) {
        if (cis.getRoleAssignments() == null || cis.getRoleAssignments().isEmpty()) {
            return;
        }
        cis.getRoleAssignments().forEach(crs -> {
            crs.getUsers().forEach(user -> this.caseRolesView.addUser((String)user, crs.getName(), new CaseRoleAction((String)user, (CaseRoleAssignmentSummary)crs){
                final /* synthetic */ String val$user;
                final /* synthetic */ CaseRoleAssignmentSummary val$crs;
                {
                    this.val$user = string;
                    this.val$crs = caseRoleAssignmentSummary;
                }

                @Override
                public String label() {
                    return CaseRolesPresenter.this.translationService.format("Remove", new Object[0]);
                }

                public void execute() {
                    CaseRolesPresenter.this.removeUserFromRole(this.val$user, this.val$crs.getName());
                }
            }));
            crs.getGroups().forEach(group -> this.caseRolesView.addGroup((String)group, crs.getName(), new CaseRoleAction((String)group, (CaseRoleAssignmentSummary)crs){
                final /* synthetic */ String val$group;
                final /* synthetic */ CaseRoleAssignmentSummary val$crs;
                {
                    this.val$group = string;
                    this.val$crs = caseRoleAssignmentSummary;
                }

                @Override
                public String label() {
                    return CaseRolesPresenter.this.translationService.format("Remove", new Object[0]);
                }

                public void execute() {
                    CaseRolesPresenter.this.removeGroupFromRole(this.val$group, this.val$crs.getName());
                }
            }));
        });
    }

    protected void addUserToRole(String userName, String roleName) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.findCaseInstance())).assignUserToRole(this.serverTemplateId, this.containerId, this.caseId, roleName, userName);
    }

    protected void addGroupToRole(String groupName, String roleName) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.findCaseInstance())).assignGroupToRole(this.serverTemplateId, this.containerId, this.caseId, roleName, groupName);
    }

    protected void removeUserFromRole(String userName, String roleName) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.findCaseInstance())).removeUserFromRole(this.serverTemplateId, this.containerId, this.caseId, roleName, userName);
    }

    protected void removeGroupFromRole(String groupName, String roleName) {
        ((CaseManagementService)this.caseService.call(Void2 -> this.findCaseInstance())).removeGroupFromRole(this.serverTemplateId, this.containerId, this.caseId, roleName, groupName);
    }

    public static interface CaseRoleAction
    extends Command {
        public String label();
    }

    public static interface NewRoleAssignmentView
    extends UberElement<CaseRolesPresenter> {
        public void show(Boolean var1, Set<String> var2, Command var3);

        public void hide();

        public String getRoleName();

        public String getUserName();
    }

    public static interface CaseRolesView
    extends UberElement<CaseRolesPresenter> {
        public void removeAllRoles();

        public void addUser(String var1, String var2, CaseRoleAction ... var3);

        public void addGroup(String var1, String var2, CaseRoleAction ... var3);

        public void setUserAddCommand(Command var1);

        public void setGroupAddCommand(Command var1);

        public void enableNewRoleAssignments();

        public void disableNewRoleAssignments();
    }
}

