/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.list;

import com.google.common.collect.Lists;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.jbpm.console.ng.cm.util.CaseInstanceSearchRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseInstanceListPresenterTest {
    @Mock
    CaseManagementService caseManagementService;
    Caller<CaseManagementService> caseService;
    @Mock
    CaseInstanceListPresenter.CaseInstanceListView view;
    @Mock
    PlaceManager placeManager;
    @InjectMocks
    CaseInstanceListPresenter presenter;
    List<CaseInstanceSummary> caseInstanceSummaryList = Lists.newArrayList((Object[])new CaseInstanceSummary[]{CaseInstanceListPresenterTest.createCaseInstance()});

    private static CaseInstanceSummary createCaseInstance() {
        return CaseInstanceSummary.builder().caseId("caseId").description("description").status(Integer.valueOf(1)).containerId("containerId").build();
    }

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        Mockito.when((Object)this.caseManagementService.getCaseInstances((CaseInstanceSearchRequest)Mockito.any(CaseInstanceSearchRequest.class))).thenReturn(this.caseInstanceSummaryList);
        this.presenter.setCaseService(this.caseService);
        Mockito.when((Object)this.view.getCaseInstanceSearchRequest()).thenReturn((Object)new CaseInstanceSearchRequest());
    }

    @Test
    public void testCancelCaseInstance() {
        CaseInstanceSummary cis = this.caseInstanceSummaryList.remove(0);
        this.presenter.cancelCaseInstance(cis);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).cancelCaseInstance(null, cis.getContainerId(), cis.getCaseId());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstances((CaseInstanceSearchRequest)Mockito.any(CaseInstanceSearchRequest.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseInstanceListPresenter.CaseInstanceListView)Mockito.verify((Object)this.view)).setCaseInstanceList((List)captor.capture());
        Assert.assertEquals((long)this.caseInstanceSummaryList.size(), (long)((List)captor.getValue()).size());
    }

    @Test
    public void testDestroyCaseInstance() {
        CaseInstanceSummary cis = this.caseInstanceSummaryList.remove(0);
        this.presenter.destroyCaseInstance(cis);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).destroyCaseInstance(null, cis.getContainerId(), cis.getCaseId());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstances((CaseInstanceSearchRequest)Mockito.any(CaseInstanceSearchRequest.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseInstanceListPresenter.CaseInstanceListView)Mockito.verify((Object)this.view)).setCaseInstanceList((List)captor.capture());
        Assert.assertEquals((long)this.caseInstanceSummaryList.size(), (long)((List)captor.getValue()).size());
    }

    @Test
    public void testRefreshData() {
        this.presenter.refreshData();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseInstances(this.view.getCaseInstanceSearchRequest());
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseInstanceListPresenter.CaseInstanceListView)Mockito.verify((Object)this.view)).setCaseInstanceList((List)captor.capture());
        Assert.assertEquals((long)this.caseInstanceSummaryList.size(), (long)((List)captor.getValue()).size());
    }

    @Test
    public void testSelectCaseInstance() {
        CaseInstanceSummary cis = CaseInstanceListPresenterTest.createCaseInstance();
        this.presenter.selectCaseInstance(cis);
        ArgumentCaptor captor = ArgumentCaptor.forClass(DefaultPlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        DefaultPlaceRequest dpr = (DefaultPlaceRequest)captor.getValue();
        Assert.assertNotNull((Object)dpr);
        Assert.assertEquals((Object)"", (Object)dpr.getParameter("serverTemplateId", null));
        Assert.assertEquals((Object)cis.getContainerId(), (Object)dpr.getParameter("containerId", null));
        Assert.assertEquals((Object)cis.getCaseId(), (Object)dpr.getParameter("caseId", null));
    }
}

