/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.newcase;

import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.console.ng.cm.client.events.CaseCreatedEvent;
import org.jbpm.console.ng.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class NewCaseInstancePresenterTest {
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<CaseCreatedEvent> caseCreatedEvent;
    @Mock
    NewCaseInstancePresenter.NewCaseInstanceView view;
    Caller<CaseManagementService> caseService;
    @Mock
    CaseManagementService caseManagementService;
    @Mock
    TranslationService translationService;
    @InjectMocks
    NewCaseInstancePresenter presenter;

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.presenter.setNotification(this.notificationEvent);
        this.presenter.setNewCaseEvent(this.caseCreatedEvent);
    }

    @Test
    public void testCreateInvalidCaseInstance() {
        this.presenter.createCaseInstance(null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((NotificationEvent)captor.getValue()).getType());
    }

    @Test
    public void testCreateCaseInstance() {
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id("id").name("name").containerId("containerId").build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinitions()).thenReturn(Arrays.asList(cds));
        this.presenter.show();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearCaseDefinitions();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setCaseDefinitions((List)captor.capture());
        List list = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cds.getName(), list.get(0));
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).show();
        this.presenter.createCaseInstance(cds.getName());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).startCaseInstance(null, cds.getContainerId(), cds.getId());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).hide();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.caseCreatedEvent)).fire(Mockito.any(CaseCreatedEvent.class));
    }
}

