/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.roles;

import com.google.common.base.Strings;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.roles.CaseRolesPresenter;
import org.jbpm.console.ng.cm.client.util.FormGroup;
import org.jbpm.console.ng.cm.client.util.FormLabel;
import org.jbpm.console.ng.cm.client.util.Modal;
import org.jbpm.console.ng.cm.client.util.Select;
import org.jbpm.console.ng.cm.client.util.ValidationState;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class NewRoleAssignmentViewImpl
implements CaseRolesPresenter.NewRoleAssignmentView {
    @Inject
    @DataField(value="role-name-group")
    FormGroup roleNameGroup;
    @Inject
    @DataField(value="role-name-help")
    Span roleNameHelp;
    @Inject
    @DataField(value="role-name-select")
    Select roleNameList;
    @Inject
    @DataField(value="role-name-label")
    FormLabel roleNameLabel;
    @Inject
    @DataField(value="user-name-label")
    FormLabel userNameLabel;
    @Inject
    @DataField(value="user-name-input")
    TextInput userNameInput;
    @Inject
    @DataField(value="user-name-help")
    Span userNameHelp;
    @Inject
    @DataField(value="user-name-group")
    FormGroup userNameGroup;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    private Boolean forUser;
    private Command okCommand;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.roleNameLabel.addRequiredIndicator();
    }

    public void init(CaseRolesPresenter presenter) {
    }

    @Override
    public void show(Boolean forUser, Set<String> roles, Command okCommand) {
        this.clearErrorMessages();
        this.clearValues();
        this.forUser = forUser;
        this.userNameLabel.getElement().setTextContent(this.translationService.format(forUser != false ? "User" : "Group", new Object[0]));
        this.userNameLabel.addRequiredIndicator();
        roles.forEach(r -> this.roleNameList.addOption((String)r));
        this.roleNameList.refresh();
        this.okCommand = okCommand;
        this.modal.show();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    private boolean validateForm() {
        boolean userNameEmpty;
        this.clearErrorMessages();
        boolean roleNameEmpty = Strings.isNullOrEmpty((String)this.roleNameList.getValue());
        if (roleNameEmpty) {
            this.roleNameList.getElement().focus();
            this.roleNameHelp.setTextContent(this.translationService.format("PleaseSelectRole", new Object[0]));
            this.roleNameGroup.setValidationState(ValidationState.ERROR);
        }
        if (userNameEmpty = Strings.isNullOrEmpty((String)this.userNameInput.getValue())) {
            this.userNameInput.focus();
            this.userNameHelp.setTextContent(this.translationService.format(this.forUser != false ? "UserRequired" : "GroupRequired", new Object[0]));
            this.userNameGroup.setValidationState(ValidationState.ERROR);
        }
        if (roleNameEmpty || userNameEmpty) {
            return false;
        }
        this.roleNameGroup.setValidationState(ValidationState.SUCCESS);
        this.userNameGroup.setValidationState(ValidationState.SUCCESS);
        return true;
    }

    private void clearValues() {
        this.roleNameList.setValue("");
        this.roleNameList.removeAllOptions();
        this.roleNameList.refresh();
        this.userNameInput.setValue("");
    }

    private void clearErrorMessages() {
        this.roleNameHelp.setTextContent("");
        this.userNameHelp.setTextContent("");
        this.userNameGroup.clearValidationState();
        this.roleNameGroup.clearValidationState();
    }

    @Override
    public String getRoleName() {
        return this.roleNameList.getValue();
    }

    @Override
    public String getUserName() {
        return this.userNameInput.getValue();
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @EventHandler(value={"assign"})
    public void onAssignClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (!this.validateForm()) {
            return;
        }
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

