/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.client.roles;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.console.ng.cm.client.roles.CaseRoleItemView;
import org.jbpm.console.ng.cm.client.roles.CaseRolesPresenter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class CaseRolesViewImpl
implements CaseRolesPresenter.CaseRolesView {
    @Inject
    @DataField(value="roles")
    private Div rolesContainer;
    @Inject
    @DataField(value="role-list")
    private Div roles;
    @Inject
    @DataField(value="footer")
    private Div footer;
    private Command userAddCommand;
    private Command groupAddCommand;
    @Inject
    private ManagedInstance<CaseRoleItemView> provider;

    public void init(CaseRolesPresenter presenter) {
    }

    @Override
    public void removeAllRoles() {
        DOMUtil.removeAllChildren((Node)this.roles);
    }

    @Override
    public void enableNewRoleAssignments() {
        DOMUtil.removeCSSClass((HTMLElement)this.footer, (String)"hidden");
    }

    @Override
    public void disableNewRoleAssignments() {
        DOMUtil.addCSSClass((HTMLElement)this.footer, (String)"hidden");
    }

    @Override
    public void setUserAddCommand(Command command) {
        this.userAddCommand = command;
    }

    @Override
    public void setGroupAddCommand(Command command) {
        this.groupAddCommand = command;
    }

    @Override
    public void addUser(String userName, String roleName, CaseRolesPresenter.CaseRoleAction ... actions) {
        this.addRoleVIew(userName, roleName, "pficon-user", actions);
    }

    @Override
    public void addGroup(String groupName, String roleName, CaseRolesPresenter.CaseRoleAction ... actions) {
        this.addRoleVIew(groupName, roleName, "pficon-users", actions);
    }

    private void addRoleVIew(String name, String roleName, String iconType, CaseRolesPresenter.CaseRoleAction ... actions) {
        CaseRoleItemView roleItemView = (CaseRoleItemView)this.provider.get();
        roleItemView.setRoleName(roleName);
        roleItemView.setName(name);
        roleItemView.setIconType(iconType);
        for (CaseRolesPresenter.CaseRoleAction action : actions) {
            roleItemView.addAction(action);
        }
        this.roles.appendChild((Node)roleItemView.getElement());
    }

    @EventHandler(value={"user-add"})
    public void onUserAddClick(@ForEvent(value={"click"}) Event e) {
        if (this.userAddCommand != null) {
            this.userAddCommand.execute();
        }
    }

    @EventHandler(value={"group-add"})
    public void onGroupAddClick(@ForEvent(value={"click"}) Event e) {
        if (this.groupAddCommand != null) {
            this.groupAddCommand.execute();
        }
    }

    public HTMLElement getElement() {
        return this.rolesContainer;
    }
}

