/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.cm.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.console.ng.cm.backend.server.RemoteCaseManagementServiceImpl;
import org.jbpm.console.ng.cm.model.CaseCommentSummary;
import org.jbpm.console.ng.cm.model.CaseDefinitionSummary;
import org.jbpm.console.ng.cm.model.CaseInstanceSummary;
import org.jbpm.console.ng.cm.model.CaseMilestoneSummary;
import org.jbpm.console.ng.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.console.ng.cm.model.CaseStageSummary;
import org.jbpm.console.ng.cm.util.CaseInstanceSearchRequest;
import org.jbpm.console.ng.cm.util.CaseMilestoneSearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Specializes
public class MockCaseManagementService
extends RemoteCaseManagementServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockCaseManagementService.class);
    private static final String CASE_DEFINITIONS_JSON = "case_definitions.json";
    private static final String CASE_MILESTONES_JSON = "case_milestones.json";
    private static final String CASE_STAGES_JSON = "case_stages.json";
    private static int commentIdGenerator = 0;
    @Inject
    protected User identity;
    private List<CaseDefinitionSummary> caseDefinitionList = Collections.emptyList();
    private List<CaseInstanceSummary> caseInstanceList = new ArrayList();
    private List<CaseStageSummary> caseStageList = new ArrayList();
    private Map<String, List<CaseCommentSummary>> caseCommentMap = new HashMap();
    private List<CaseMilestoneSummary> caseMilestoneList = new ArrayList();

    @PostConstruct
    public void init() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CASE_DEFINITIONS_JSON);
            this.caseDefinitionList = Arrays.asList((Object[])mapper.readValue(inputStream, CaseDefinitionSummary[].class));
            this.caseMilestoneList = Arrays.asList((Object[])mapper.readValue(Thread.currentThread().getContextClassLoader().getResourceAsStream(CASE_MILESTONES_JSON), CaseMilestoneSummary[].class));
            this.caseStageList = Arrays.asList((Object[])mapper.readValue(Thread.currentThread().getContextClassLoader().getResourceAsStream(CASE_STAGES_JSON), CaseStageSummary[].class));
            LOGGER.info("Loaded {} case definitions", (Object)this.caseDefinitionList.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load json data file", (Throwable)e);
        }
    }

    public CaseDefinitionSummary getCaseDefinition(String serverTemplateId, String containerId, String caseDefinitionId) {
        return this.caseDefinitionList.stream().filter(c -> c.getId().equals(caseDefinitionId)).findFirst().get();
    }

    public List<CaseDefinitionSummary> getCaseDefinitions() {
        return this.caseDefinitionList;
    }

    public String startCaseInstance(String serverTemplateId, String containerId, String caseDefinitionId) {
        CaseInstanceSummary ci = CaseInstanceSummary.builder().caseId("CASE-" + Strings.padStart((String)String.valueOf(this.caseInstanceList.size() + 1), (int)5, (char)'0')).owner(this.identity.getIdentifier()).startedAt(new Date()).caseDefinitionId(caseDefinitionId).status(Integer.valueOf(1)).description("New case instance for development").containerId(containerId).stages(this.caseStageList).build();
        this.caseInstanceList.add(ci);
        return ci.getCaseId();
    }

    public List<CaseInstanceSummary> getCaseInstances(CaseInstanceSearchRequest request) {
        return this.caseInstanceList.stream().filter(c -> c.getStatus().equals(request.getStatus())).sorted(this.getCaseInstanceSummaryComparator(request)).collect(Collectors.toList());
    }

    public CaseInstanceSummary getCaseInstance(String serverTemplateId, String containerId, String caseId) {
        return this.caseInstanceList.stream().filter(c -> c.getCaseId().equals(caseId)).findFirst().get();
    }

    public void cancelCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.executeOnCaseInstance(caseId, c -> c.setStatus(Integer.valueOf(3)));
    }

    public void destroyCaseInstance(String serverTemplateId, String containerId, String caseId) {
        this.executeOnCaseInstance(caseId, c -> c.setStatus(Integer.valueOf(3)));
    }

    public List<CaseCommentSummary> getComments(String serverTemplateId, String containerId, String caseId) {
        return Optional.ofNullable(this.caseCommentMap.get(caseId)).orElse(Collections.emptyList());
    }

    public void addComment(String serverTemplateId, String containerId, String caseId, String author, String text) {
        List commentSummaryList = this.caseCommentMap.getOrDefault(caseId, new ArrayList());
        String newId = String.valueOf(commentIdGenerator++);
        CaseCommentSummary caseCommentSummary = CaseCommentSummary.builder().id(newId).author(author).text(text).addedAt(new Date()).build();
        commentSummaryList.add(caseCommentSummary);
        this.caseCommentMap.putIfAbsent(caseId, commentSummaryList);
    }

    public void updateComment(String serverTemplateId, String containerId, String caseId, String commentId, String author, String text) {
        Optional.ofNullable(this.caseCommentMap.get(caseId)).ifPresent(l -> l.stream().filter(c -> c.getId().equals(commentId)).findFirst().ifPresent(c -> c.setText(text)));
    }

    public void removeComment(String serverTemplateId, String containerId, String caseId, String commentId) {
        Optional.ofNullable(this.caseCommentMap.get(caseId)).ifPresent(l -> l.stream().filter(c -> c.getId().equals(commentId)).findFirst().ifPresent(c -> l.remove(c)));
    }

    public void assignUserToRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getUsers().add(user));
    }

    public void assignGroupToRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getGroups().add(group));
    }

    public void removeUserFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String user) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getUsers().remove(user));
    }

    public void removeGroupFromRole(String serverTemplateId, String containerId, String caseId, String roleName, String group) {
        this.executeOnCaseRole(caseId, roleName, r -> r.getGroups().remove(group));
    }

    private void executeOnCaseInstance(String caseId, Consumer<CaseInstanceSummary> consumer) {
        this.caseInstanceList.stream().filter(c -> c.getCaseId().equals(caseId)).findFirst().ifPresent(consumer);
    }

    private void executeOnCaseRole(String caseId, String roleName, Consumer<CaseRoleAssignmentSummary> consumer) {
        this.executeOnCaseInstance(caseId, c -> {
            CaseRoleAssignmentSummary role = c.getRoleAssignments().stream().filter(r -> r.getName().equals(roleName)).findFirst().orElseGet(() -> {
                CaseRoleAssignmentSummary newRole = CaseRoleAssignmentSummary.builder().name(roleName).build();
                c.getRoleAssignments().add(newRole);
                return newRole;
            });
            consumer.accept(role);
        });
    }

    public List<CaseMilestoneSummary> getCaseMilestones(String containerId, String caseId, CaseMilestoneSearchRequest request) {
        return this.caseMilestoneList.stream().sorted(this.getCaseMilestoneSummaryComparator(request)).collect(Collectors.toList());
    }
}

