/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.service.impl;

import java.net.HttpURLConnection;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.StringUtils;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.dashboard.renderer.service.ConnectionStatus;
import org.jbpm.dashboard.renderer.service.DashboardRendererService;

@Service
@ApplicationScoped
public class DashboardRendererServiceImpl
implements DashboardRendererService {
    public static int PING_TIMEOUT = 1000;

    public ConnectionStatus getAppStatus(String theUrl) {
        ConnectionStatus connectionStatus = new ConnectionStatus();
        try {
            String targetUrl = this.resolveUrl(theUrl);
            int status = this.pingUrl(targetUrl);
            connectionStatus.setStatus(status);
        }
        catch (Exception e) {
            e.printStackTrace();
            connectionStatus.setStatus(-1);
        }
        return connectionStatus;
    }

    protected int pingUrl(String anUrl) throws Exception {
        int timeout = PING_TIMEOUT;
        String bindTimeout = System.getProperty("dashbuilder.bind.timeout");
        if (!StringUtils.isBlank((CharSequence)bindTimeout)) {
            timeout = Integer.parseInt(bindTimeout);
        }
        URL url = new URL(anUrl);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(timeout);
        return urlConnection.getResponseCode();
    }

    protected String resolveUrl(String anUrl) throws Exception {
        String bindAddress = System.getProperty("dashbuilder.bind.address");
        String bindPort = System.getProperty("dashbuilder.bind.port");
        URL url = new URL(anUrl);
        String host = url.getHost();
        int port = url.getPort();
        String targetUrl = anUrl;
        if (!StringUtils.isBlank((CharSequence)bindAddress) && !host.equals(bindAddress)) {
            targetUrl = targetUrl.replace(host, bindAddress);
        }
        if (!StringUtils.isBlank((CharSequence)bindPort) && port != Integer.parseInt(bindPort)) {
            targetUrl = targetUrl.replace(Integer.toString(port), bindPort);
        }
        return !anUrl.equals(targetUrl) ? targetUrl : anUrl;
    }
}

