/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client.panel;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.dashboard.renderer.client.panel.DashboardFactory;
import org.jbpm.dashboard.renderer.client.panel.DashboardKpis;
import org.jbpm.dashboard.renderer.client.panel.events.ProcessDashboardFocusEvent;
import org.jbpm.dashboard.renderer.client.panel.events.TaskDashboardFocusEvent;
import org.jbpm.dashboard.renderer.client.panel.formatter.DurationFormatter;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardI18n;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class ProcessDashboard
implements IsWidget {
    protected View view;
    protected ProcessBreadCrumb processBreadCrumb;
    protected DashboardFactory dashboardFactory;
    protected DataSetClientServices dataSetClientServices;
    protected DisplayerLocator displayerLocator;
    protected DisplayerCoordinator displayerCoordinator;
    protected PlaceManager placeManager;
    protected Event<ProcessInstanceSelectionEvent> instanceSelectionEvent;
    protected Event<ProcessDashboardFocusEvent> processDashboardFocusEvent;
    protected DashboardI18n i18n;
    protected MetricDisplayer totalMetric;
    protected MetricDisplayer activeMetric;
    protected MetricDisplayer pendingMetric;
    protected MetricDisplayer suspendedMetric;
    protected MetricDisplayer abortedMetric;
    protected MetricDisplayer completedMetric;
    protected Displayer processesByType;
    protected Displayer processesByUser;
    protected Displayer processesByStartDate;
    protected Displayer processesByEndDate;
    protected Displayer processesByRunningTime;
    protected Displayer processesByVersion;
    protected TableDisplayer processesTable;
    protected MetricDisplayer selectedMetric = null;
    protected String selectedProcess = null;
    protected List<Displayer> metricsGroup = new ArrayList<Displayer>();
    protected List<Displayer> chartsGroup = new ArrayList<Displayer>();
    protected String totalProcessesTitle;
    public static final String PROCESS_DETAILS_SCREEN_ID = "Process Instance Details Multi";
    DisplayerListener dashboardListener = new AbstractDisplayerListener(){

        public void onDraw(Displayer displayer) {
            DataSet ds;
            if (ProcessDashboard.this.totalMetric == displayer && (ds = displayer.getDataSetHandler().getLastDataSet()).getRowCount() == 0) {
                ProcessDashboard.this.showBlankDashboard();
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
            if ("PROCESSNAME".equals(groupOp.getColumnGroup().getSourceId())) {
                Interval interval = (Interval)groupOp.getSelectedIntervalList().get(0);
                ProcessDashboard.this.changeCurrentProcess(interval.getName());
            }
        }

        public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
            for (DataSetGroup groupOp : groupOps) {
                if (!"PROCESSNAME".equals(groupOp.getColumnGroup().getSourceId())) continue;
                ProcessDashboard.this.resetCurrentProcess();
                return;
            }
        }

        public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
            if (ProcessDashboard.this.metricsGroup.contains(displayer)) {
                ProcessDashboard.this.changeCurrentMetric((MetricDisplayer)displayer);
            }
        }

        public void onFilterReset(Displayer displayer, DataSetFilter filter) {
            if (ProcessDashboard.this.metricsGroup.contains(displayer)) {
                ProcessDashboard.this.resetCurrentMetric();
            }
        }
    };

    @Inject
    public ProcessDashboard(View view, ProcessBreadCrumb processBreadCrumb, DashboardFactory dashboardFactory, DataSetClientServices dataSetClientServices, DisplayerLocator displayerLocator, DisplayerCoordinator displayerCoordinator, PlaceManager placeManager, Event<ProcessInstanceSelectionEvent> instanceSelectionEvent, Event<ProcessDashboardFocusEvent> processDashboardFocusEvent) {
        this.view = view;
        this.i18n = view.getI18nService();
        this.processBreadCrumb = processBreadCrumb;
        this.dashboardFactory = dashboardFactory;
        this.dataSetClientServices = dataSetClientServices;
        this.displayerLocator = displayerLocator;
        this.displayerCoordinator = displayerCoordinator;
        this.placeManager = placeManager;
        this.instanceSelectionEvent = instanceSelectionEvent;
        this.processDashboardFocusEvent = processDashboardFocusEvent;
        this.init();
    }

    protected void init() {
        this.processBreadCrumb.setOnRootSelectedCommand(new Command(){

            public void execute() {
                ProcessDashboard.this.resetProcessBreadcrumb();
            }
        });
        this.view.showLoading();
        DisplayerSettings totalProcesses = DashboardKpis.processTotal(this.i18n);
        this.totalProcessesTitle = totalProcesses.getTitle();
        this.totalMetric = this.createMetricDisplayer(totalProcesses);
        this.activeMetric = this.createMetricDisplayer(DashboardKpis.processesActive(this.i18n));
        this.pendingMetric = this.createMetricDisplayer(DashboardKpis.processesPending(this.i18n));
        this.suspendedMetric = this.createMetricDisplayer(DashboardKpis.processesSuspended(this.i18n));
        this.abortedMetric = this.createMetricDisplayer(DashboardKpis.processesAborted(this.i18n));
        this.completedMetric = this.createMetricDisplayer(DashboardKpis.processesCompleted(this.i18n));
        this.processesByType = this.createDisplayer(DashboardKpis.processesByType(this.i18n));
        this.processesByUser = this.createDisplayer(DashboardKpis.processesByUser(this.i18n));
        this.processesByStartDate = this.createDisplayer(DashboardKpis.processesByStartDate(this.i18n));
        this.processesByEndDate = this.createDisplayer(DashboardKpis.processesByEndDate(this.i18n));
        this.processesByRunningTime = this.createDisplayer(DashboardKpis.processesByRunningTime(this.i18n));
        this.processesByVersion = this.createDisplayer(DashboardKpis.processesByVersion(this.i18n));
        this.processesTable = this.createTableDisplayer(DashboardKpis.processesTable(this.i18n));
        this.view.init(this, (Displayer)this.totalMetric, (Displayer)this.activeMetric, (Displayer)this.pendingMetric, (Displayer)this.suspendedMetric, (Displayer)this.abortedMetric, (Displayer)this.completedMetric, this.processesByType, this.processesByUser, this.processesByStartDate, this.processesByEndDate, this.processesByRunningTime, this.processesByVersion, (Displayer)this.processesTable);
        this.metricsGroup.add((Displayer)this.totalMetric);
        this.metricsGroup.add((Displayer)this.activeMetric);
        this.metricsGroup.add((Displayer)this.pendingMetric);
        this.metricsGroup.add((Displayer)this.suspendedMetric);
        this.metricsGroup.add((Displayer)this.abortedMetric);
        this.metricsGroup.add((Displayer)this.completedMetric);
        this.chartsGroup.add(this.processesByType);
        this.chartsGroup.add(this.processesByStartDate);
        this.chartsGroup.add(this.processesByEndDate);
        this.chartsGroup.add(this.processesByUser);
        this.chartsGroup.add(this.processesByRunningTime);
        this.chartsGroup.add(this.processesByVersion);
        this.chartsGroup.add((Displayer)this.processesTable);
        this.displayerCoordinator.addDisplayers(this.metricsGroup);
        this.displayerCoordinator.addDisplayers(this.chartsGroup);
        this.displayerCoordinator.addNotificationVeto(this.metricsGroup);
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.dashboardListener});
        this.displayerCoordinator.drawAll(new Command(){

            public void execute() {
                ProcessDashboard.this.view.hideLoading();
                ProcessDashboard.this.totalMetric.filterApply();
            }
        }, new Command(){

            public void execute() {
                ProcessDashboard.this.view.hideLoading();
            }
        });
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public ProcessBreadCrumb getProcessBreadCrumb() {
        return this.processBreadCrumb;
    }

    public MetricDisplayer getTotalMetric() {
        return this.totalMetric;
    }

    public MetricDisplayer getActiveMetric() {
        return this.activeMetric;
    }

    public MetricDisplayer getPendingMetric() {
        return this.pendingMetric;
    }

    public MetricDisplayer getSuspendedMetric() {
        return this.suspendedMetric;
    }

    public MetricDisplayer getAbortedMetric() {
        return this.abortedMetric;
    }

    public MetricDisplayer getCompletedMetric() {
        return this.completedMetric;
    }

    public Displayer getProcessesByType() {
        return this.processesByType;
    }

    public Displayer getProcessesByUser() {
        return this.processesByUser;
    }

    public Displayer getProcessesByStartDate() {
        return this.processesByStartDate;
    }

    public Displayer getProcessesByEndDate() {
        return this.processesByEndDate;
    }

    public Displayer getProcessesByRunningTime() {
        return this.processesByRunningTime;
    }

    public Displayer getProcessesByVersion() {
        return this.processesByVersion;
    }

    public TableDisplayer getProcessesTable() {
        return this.processesTable;
    }

    public MetricDisplayer getSelectedMetric() {
        return this.selectedMetric;
    }

    public String getSelectedProcess() {
        return this.selectedProcess;
    }

    public MetricDisplayer createMetricDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        MetricDisplayer metricDisplayer = this.dashboardFactory.createMetricDisplayer();
        metricDisplayer.setDisplayerSettings(settings);
        metricDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, settings.getDataSetLookup()));
        return metricDisplayer;
    }

    public Displayer createDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        return this.displayerLocator.lookupDisplayer(settings);
    }

    public TableDisplayer createTableDisplayer(DisplayerSettings settings) {
        PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)settings);
        final TableDisplayer tableDisplayer = this.dashboardFactory.createTableDisplayer();
        tableDisplayer.setDisplayerSettings(settings);
        tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.dataSetClientServices, settings.getDataSetLookup()));
        tableDisplayer.addFormatter("DURATION", (ValueFormatter)new DurationFormatter("START_DATE", "END_DATE"));
        tableDisplayer.setOnCellSelectedCommand(new Command(){

            public void execute() {
                ProcessDashboard.this.tableCellSelected(tableDisplayer.getSelectedCellColumn(), tableDisplayer.getSelectedCellRow());
            }
        });
        return tableDisplayer;
    }

    public void resetCurrentMetric() {
        this.selectedMetric = null;
        this.updateHeaderText();
    }

    public void changeCurrentMetric(MetricDisplayer metric) {
        if (metric.isFilterOn()) {
            if (this.selectedMetric != null && this.selectedMetric != metric) {
                this.selectedMetric.filterReset();
            }
            this.selectedMetric = metric;
            this.updateHeaderText();
        } else {
            this.selectedMetric = null;
            this.updateHeaderText();
        }
    }

    public void changeCurrentProcess(String name) {
        this.selectedProcess = name;
        this.updateHeaderText();
        this.view.showBreadCrumb(name);
    }

    public void resetCurrentProcess() {
        this.selectedProcess = null;
        this.updateHeaderText();
        this.view.hideBreadCrumb();
    }

    public void resetProcessBreadcrumb() {
        ((AbstractDisplayer)this.processesByType).filterReset();
        ((AbstractDisplayer)this.processesByRunningTime).filterReset();
        this.processesByType.redraw();
        this.processesByRunningTime.redraw();
        this.view.hideBreadCrumb();
    }

    public void showBlankDashboard() {
    }

    public void updateHeaderText() {
        if (this.selectedProcess == null) {
            String selected;
            String string = selected = this.selectedMetric != null ? this.selectedMetric.getDisplayerSettings().getTitle() : null;
            if (selected == null || this.totalProcessesTitle.equals(selected)) {
                this.view.setHeaderText(this.i18n.allProcesses());
            } else {
                this.view.setHeaderText(selected);
            }
        } else {
            String status = "";
            if (this.activeMetric == this.selectedMetric) {
                status = this.i18n.processStatusActive();
            } else if (this.pendingMetric == this.selectedMetric) {
                status = this.i18n.processStatusPending();
            } else if (this.suspendedMetric == this.selectedMetric) {
                status = this.i18n.processStatusSuspended();
            } else if (this.abortedMetric == this.selectedMetric) {
                status = this.i18n.processStatusAborted();
            } else if (this.completedMetric == this.selectedMetric) {
                status = this.i18n.processStatusCompleted();
            }
            this.view.setHeaderText(this.i18n.selectedProcessStatusHeader(status, this.selectedProcess));
        }
    }

    public void tableCellSelected(String columnId, int rowIndex) {
        DataSet ds = this.processesTable.getDataSetHandler().getLastDataSet();
        String deploymentId = ds.getValueAt(rowIndex, "EXTERNALID").toString();
        Long processInstanceId = Double.valueOf(ds.getValueAt(rowIndex, "PROCESSINSTANCEID").toString()).longValue();
        String processDefId = ds.getValueAt(rowIndex, "PROCESSID").toString();
        String processDefName = ds.getValueAt(rowIndex, "PROCESSNAME").toString();
        Integer processInstanceStatus = Double.valueOf(ds.getValueAt(rowIndex, "STATUS").toString()).intValue();
        this.openProcessDetailsScreen();
        this.instanceSelectionEvent.fire((Object)new ProcessInstanceSelectionEvent(deploymentId, processInstanceId, processDefId, processDefName, processInstanceStatus));
    }

    public void showDashboard() {
        this.view.showDashboard();
        this.processDashboardFocusEvent.fire((Object)new ProcessDashboardFocusEvent());
        this.closeProcessDetailsScreen();
    }

    public void openProcessDetailsScreen() {
        this.processDashboardFocusEvent.fire((Object)new ProcessDashboardFocusEvent());
        PlaceStatus status = this.placeManager.getStatus(PROCESS_DETAILS_SCREEN_ID);
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo(PROCESS_DETAILS_SCREEN_ID);
        }
    }

    public void closeProcessDetailsScreen() {
        PlaceStatus status = this.placeManager.getStatus(PROCESS_DETAILS_SCREEN_ID);
        if (status == PlaceStatus.OPEN) {
            this.placeManager.closePlace(PROCESS_DETAILS_SCREEN_ID);
        }
    }

    public void showProcessesTable() {
        this.view.showInstances();
        this.processesTable.redraw();
        this.processDashboardFocusEvent.fire((Object)new ProcessDashboardFocusEvent());
    }

    public void onManagingTasks(@Observes TaskDashboardFocusEvent event) {
        this.closeProcessDetailsScreen();
    }

    public static interface View
    extends IsWidget {
        public void init(ProcessDashboard var1, Displayer var2, Displayer var3, Displayer var4, Displayer var5, Displayer var6, Displayer var7, Displayer var8, Displayer var9, Displayer var10, Displayer var11, Displayer var12, Displayer var13, Displayer var14);

        public void showBreadCrumb(String var1);

        public void hideBreadCrumb();

        public void setHeaderText(String var1);

        public void showLoading();

        public void hideLoading();

        public void showDashboard();

        public void showInstances();

        public DashboardI18n getI18nService();
    }
}

