/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client;

import javax.enterprise.event.Event;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.console.ng.pr.model.events.ProcessInstanceSelectionEvent;
import org.jbpm.dashboard.renderer.client.AbstractDashboardTest;
import org.jbpm.dashboard.renderer.client.ProcessDashboardData;
import org.jbpm.dashboard.renderer.client.panel.ProcessDashboard;
import org.jbpm.dashboard.renderer.client.panel.events.ProcessDashboardFocusEvent;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessDashboardTest
extends AbstractDashboardTest {
    @Mock
    ProcessDashboard.View view;
    @Mock
    ProcessBreadCrumb processBreadCrumb;
    @Mock
    Event<ProcessInstanceSelectionEvent> instanceSelectionEvent;
    @Mock
    Event<ProcessDashboardFocusEvent> processDashboardFocusEvent;
    ProcessDashboard presenter;
    DataSet dataSet;

    public void registerDataset() throws Exception {
        this.dataSet = ProcessDashboardData.INSTANCE.toDataSet();
        this.dataSet.setUUID("processesMonitoring");
        this.clientDataSetManager.registerDataSet(this.dataSet);
    }

    @Override
    @Before
    public void init() throws Exception {
        super.init();
        this.registerDataset();
        Mockito.when((Object)this.view.getI18nService()).thenReturn((Object)this.i18n);
        this.presenter = new ProcessDashboard(this.view, this.processBreadCrumb, this.dashboardFactory, this.clientServices, this.displayerLocator, this.displayerCoordinator, this.placeManager, this.instanceSelectionEvent, this.processDashboardFocusEvent);
    }

    @Test
    public void testDrawAll() {
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).init(this.presenter, (Displayer)this.presenter.getTotalMetric(), (Displayer)this.presenter.getActiveMetric(), (Displayer)this.presenter.getPendingMetric(), (Displayer)this.presenter.getSuspendedMetric(), (Displayer)this.presenter.getAbortedMetric(), (Displayer)this.presenter.getCompletedMetric(), (Displayer)this.presenter.getProcessesByType(), (Displayer)this.presenter.getProcessesByUser(), (Displayer)this.presenter.getProcessesByStartDate(), (Displayer)this.presenter.getProcessesByEndDate(), (Displayer)this.presenter.getProcessesByRunningTime(), (Displayer)this.presenter.getProcessesByVersion(), (Displayer)this.presenter.getProcessesTable());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showLoading();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTotalMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getActiveMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getPendingMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getSuspendedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getAbortedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getCompletedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByType());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByUser());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByStartDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByEndDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByRunningTime());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByVersion());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesTable());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).hideLoading();
    }

    @Test
    public void test_JBPM_4851_Fix() {
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getTotalMetric().getView())).setFilterActive(true);
        Assert.assertEquals((Object)this.presenter.getTotalMetric().isFilterOn(), (Object)true);
    }

    @Test
    public void testShowInstances() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showProcessesTable();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showInstances();
        ((Event)Mockito.verify(this.processDashboardFocusEvent)).fire(Mockito.any(ProcessDashboardFocusEvent.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getProcessesTable());
    }

    @Test
    public void testShowDashboard() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showDashboard();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showDashboard();
        ((Event)Mockito.verify(this.processDashboardFocusEvent)).fire(Mockito.any(ProcessDashboardFocusEvent.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)this.presenter.getProcessesTable());
    }

    @Test
    public void testTotalMetric() {
        MetricDisplayer displayer = this.presenter.getTotalMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)4.0);
    }

    @Test
    public void testActiveMetric() {
        MetricDisplayer displayer = this.presenter.getActiveMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)3.0);
    }

    @Test
    public void testCompletedMetric() {
        MetricDisplayer displayer = this.presenter.getCompletedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)1.0);
    }

    @Test
    public void testAbortedTotalMetric() {
        MetricDisplayer displayer = this.presenter.getAbortedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testPendingMetric() {
        MetricDisplayer displayer = this.presenter.getPendingMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testSuspendedMetric() {
        MetricDisplayer displayer = this.presenter.getSuspendedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testProcessesByEndDate() {
        AbstractDisplayer displayer = this.presenter.getProcessesByEndDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01-02", "1.00"}}, (int)0);
    }

    @Test
    public void testProcessesByStartDate() {
        AbstractDisplayer displayer = this.presenter.getProcessesByStartDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01-01", "4.00"}}, (int)0);
    }

    @Test
    public void testProcessesByRunningTime() {
        AbstractDisplayer displayer = this.presenter.getProcessesByRunningTime();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process B", "1.00", "100,000.00", "Process B", "1.00"}}, (int)0);
    }

    @Test
    public void testProcessesByType() {
        AbstractDisplayer displayer = this.presenter.getProcessesByType();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process A", "2.00"}, {"Process B", "2.00"}}, (int)0);
    }

    @Test
    public void testProcessesByUser() {
        AbstractDisplayer displayer = this.presenter.getProcessesByUser();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"user1", "2.00"}, {"user2", "2.00"}}, (int)0);
    }

    @Test
    public void testProcessesByVersion() {
        AbstractDisplayer displayer = this.presenter.getProcessesByVersion();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1", "4.00"}}, (int)0);
    }

    @Test
    public void testProcessesTable() {
        TableDisplayer displayer = this.presenter.getProcessesTable();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testSelectProcess() {
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.getProcessesByType().filterUpdate("processName", 1);
        Assert.assertEquals((Object)this.presenter.getSelectedProcess(), (Object)"Process B");
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showBreadCrumb("Process B");
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)12))).onRedraw((Displayer)Mockito.any(Displayer.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onError((Displayer)Mockito.any(Displayer.class), (ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
    }

    @Test
    public void testResetProcess() {
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        this.presenter.resetCurrentProcess();
        Assert.assertNull((Object)this.presenter.getSelectedProcess());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).hideBreadCrumb();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(Mockito.anyString());
    }

    @Test
    public void testSelectMetric() {
        this.presenter.resetCurrentMetric();
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        activeMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)activeMetric);
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterEnabled((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}}, (int)0);
    }

    @Test
    public void testResetMetric() {
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        activeMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view});
        activeMetric.filterReset();
        Assert.assertNull((Object)this.presenter.getSelectedMetric());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testSwitchMetric() {
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        MetricDisplayer completedMetric = this.presenter.getCompletedMetric();
        activeMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view});
        completedMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)completedMetric);
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)completedMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testOpenInstanceDetails() {
        Mockito.when((Object)this.placeManager.getStatus("Process Instance Details Multi")).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.tableCellSelected("processInstanceId", 3);
        ((Event)Mockito.verify(this.instanceSelectionEvent)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((Event)Mockito.verify(this.processDashboardFocusEvent)).fire(Mockito.any(ProcessDashboardFocusEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("Process Instance Details Multi");
    }
}

