/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client;

import java.util.Arrays;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jbpm.dashboard.renderer.client.panel.AbstractDashboard;
import org.jbpm.dashboard.renderer.client.panel.DashboardFactory;
import org.jbpm.dashboard.renderer.client.panel.i18n.DashboardI18n;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.PlaceManager;

public abstract class AbstractDashboardTest
extends AbstractDisplayerTest {
    DashboardI18n i18n;
    @Mock
    DisplayerListener displayerListener;
    @Mock
    DashboardFactory dashboardFactory;
    @Mock
    PlaceManager placeManager;
    DisplayerCoordinator displayerCoordinator;

    @Before
    public void init() throws Exception {
        super.init();
        this.displayerCoordinator = new DisplayerCoordinator(this.rendererManager);
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.displayerListener});
        ((DashboardFactory)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return AbstractDashboardTest.this.initDisplayer((AbstractDisplayer)new MetricDisplayer((MetricDisplayer.View)Mockito.mock(MetricDisplayer.View.class)), null);
            }
        }).when((Object)this.dashboardFactory)).createMetricDisplayer();
        ((DashboardFactory)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return AbstractDashboardTest.this.initDisplayer((AbstractDisplayer)new TableDisplayer((TableDisplayer.View)Mockito.mock(TableDisplayer.View.class)), null);
            }
        }).when((Object)this.dashboardFactory)).createTableDisplayer();
        this.i18n = (DashboardI18n)Mockito.mock(DashboardI18n.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getMethod().getName() + Arrays.deepToString(invocation.getArguments());
            }
        });
        Mockito.when((Object)this.getView().getI18nService()).thenReturn((Object)this.i18n);
        this.registerDataset();
    }

    protected abstract void registerDataset() throws Exception;

    protected abstract AbstractDashboard.View getView();

    protected abstract AbstractDashboard getPresenter();

    protected void verifyMetricHeaderText(String process, MetricDisplayer metricDisplayer, String expected) {
        metricDisplayer.filterApply();
        Assert.assertEquals((Object)this.getPresenter().getSelectedMetric(), (Object)metricDisplayer);
        Mockito.reset((Object[])new AbstractDashboard.View[]{this.getView()});
        this.getPresenter().changeCurrentProcess(process);
        ((AbstractDashboard.View)Mockito.verify((Object)this.getView())).setHeaderText(expected);
    }
}

