/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.dm.client.document.list;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.console.ng.dm.client.document.list.DocumentListPresenter;
import org.jbpm.console.ng.dm.client.i18n.Constants;
import org.jbpm.console.ng.dm.model.CMSContentSummary;
import org.jbpm.console.ng.dm.model.events.DocumentRemoveSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsHomeSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsListSearchEvent;
import org.jbpm.console.ng.dm.model.events.DocumentsParentSearchEvent;
import org.jbpm.console.ng.ga.model.GenericSummary;
import org.jbpm.console.ng.gc.client.list.base.AbstractListPresenter;
import org.jbpm.console.ng.gc.client.list.base.AbstractListView;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class DocumentListViewImpl
extends AbstractListView<CMSContentSummary, DocumentListPresenter>
implements DocumentListPresenter.DocumentListView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private Column actionsColumn;
    private ButtonGroup filtersButtonGroup;
    public Button parentLink;
    public Anchor pathLink;
    public Button homeLink;
    public Button newLink;
    @Inject
    private Event<DocumentsListSearchEvent> selectDocEvent;
    @Inject
    private Event<DocumentsParentSearchEvent> parentDocEvent;
    @Inject
    private Event<DocumentsHomeSearchEvent> homeDocEvent;
    @Inject
    private Event<DocumentRemoveSearchEvent> removeDocEvent;
    @Inject
    private Event<NotificationEvent> notification;

    public void init(DocumentListPresenter presenter) {
        ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add(this.constants.DocumentID());
        bannedColumns.add(this.constants.DocumentName());
        bannedColumns.add(this.constants.Actions());
        ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add(this.constants.DocumentID());
        initColumns.add(this.constants.DocumentName());
        initColumns.add(this.constants.Actions());
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences("DocumentListGrid", initColumns, bannedColumns));
        this.initFiltersBar();
        this.initPathLink();
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DocumentListViewImpl.this.selectedRow == -1) {
                    DocumentListViewImpl.this.listGrid.setRowStyles(DocumentListViewImpl.this.selectedStyles);
                    DocumentListViewImpl.this.selectedRow = DocumentListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DocumentListViewImpl.this.listGrid.redraw();
                } else if (DocumentListViewImpl.this.listGrid.getKeyboardSelectedRow() != DocumentListViewImpl.this.selectedRow) {
                    DocumentListViewImpl.this.listGrid.setRowStyles(DocumentListViewImpl.this.selectedStyles);
                    DocumentListViewImpl.this.selectedRow = DocumentListViewImpl.this.listGrid.getKeyboardSelectedRow();
                    DocumentListViewImpl.this.listGrid.redraw();
                } else {
                    close = true;
                }
                DocumentListViewImpl.this.selectedItem = (GenericSummary)DocumentListViewImpl.this.selectionModel.getLastSelectedObject();
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<CMSContentSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<CMSContentSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<CMSContentSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && DocumentListViewImpl.this.listGrid.getColumnIndex(DocumentListViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        this.listGrid.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        Button configRepoButton = new Button();
        configRepoButton.setIcon(IconType.COG);
        configRepoButton.setTitle(Constants.INSTANCE.ConfigurationPanel());
        configRepoButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PlaceStatus instanceDetailsStatus = DocumentListViewImpl.this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("CMIS Configuration"));
                if (instanceDetailsStatus == PlaceStatus.OPEN) {
                    DocumentListViewImpl.this.placeManager.closePlace("CMIS Configuration");
                }
                DocumentListViewImpl.this.placeManager.goTo("CMIS Configuration");
            }
        });
        this.listGrid.getRightToolbar().add((Widget)configRepoButton);
        this.listGrid.setEmptyTableCaption(this.constants.No_Documents_Available());
        this.listGrid.setRowStyles(this.selectedStyles);
    }

    public void initColumns() {
        Column<CMSContentSummary, ?> idColumn = this.initIdColumn();
        Column<CMSContentSummary, ?> processNameColumn = this.initNameColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(idColumn, this.constants.DocumentID()));
        columnMetas.add(new ColumnMeta(processNameColumn, this.constants.DocumentName()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        this.listGrid.addColumns(columnMetas);
    }

    private Column<CMSContentSummary, ?> initIdColumn() {
        Column<CMSContentSummary, String> idColumn = new Column<CMSContentSummary, String>((Cell)new TextCell()){

            public String getValue(CMSContentSummary object) {
                return object.getId();
            }
        };
        idColumn.setSortable(true);
        return idColumn;
    }

    private Column<CMSContentSummary, ?> initNameColumn() {
        Column<CMSContentSummary, String> processNameColumn = new Column<CMSContentSummary, String>((Cell)new TextCell()){

            public String getValue(CMSContentSummary object) {
                return object.getName();
            }
        };
        processNameColumn.setSortable(true);
        return processNameColumn;
    }

    private Column<CMSContentSummary, ?> initActionsColumn() {
        LinkedList<Object> cells = new LinkedList<Object>();
        cells.add(new RemoveHasCell("Remove", new ActionCell.Delegate<CMSContentSummary>(){

            public void execute(CMSContentSummary process) {
                DocumentListViewImpl.this.removeDocEvent.fire((Object)new DocumentRemoveSearchEvent(process));
            }
        }));
        cells.add(new GoHasCell("Go", new ActionCell.Delegate<CMSContentSummary>(){

            public void execute(CMSContentSummary process) {
                DocumentListViewImpl.this.selectDocEvent.fire((Object)new DocumentsListSearchEvent(process));
                DocumentListViewImpl.this.pathLink.setText(process.getPath());
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        return new Column<CMSContentSummary, CMSContentSummary>((Cell)cell){

            public CMSContentSummary getValue(CMSContentSummary object) {
                return object;
            }
        };
    }

    private void initFiltersBar() {
        HorizontalPanel filtersBar = new HorizontalPanel();
        this.parentLink = new Button();
        this.parentLink.setIcon(IconType.BACKWARD);
        this.parentLink.setSize(ButtonSize.SMALL);
        this.parentLink.setText(this.constants.Parent());
        this.parentLink.setEnabled(true);
        this.parentLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if ("click".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    DocumentListViewImpl.this.parentDocEvent.fire((Object)new DocumentsParentSearchEvent());
                    DocumentListViewImpl.this.pathLink.setText(((DocumentListPresenter)((DocumentListViewImpl)DocumentListViewImpl.this).presenter).currentCMSContentSummary.getParent().getPath());
                }
            }
        });
        this.homeLink = new Button();
        this.homeLink.setIcon(IconType.HOME);
        this.homeLink.setSize(ButtonSize.SMALL);
        this.homeLink.setText(this.constants.Home());
        this.homeLink.setEnabled(true);
        this.homeLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if ("click".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    DocumentListViewImpl.this.homeDocEvent.fire((Object)new DocumentsHomeSearchEvent());
                    DocumentListViewImpl.this.pathLink.setText("/");
                }
            }
        });
        this.newLink = new Button();
        this.newLink.setIcon(IconType.PLUS);
        this.newLink.setSize(ButtonSize.SMALL);
        this.newLink.setText(this.constants.New());
        this.newLink.setEnabled(true);
        this.newLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                DefaultPlaceRequest req = new DefaultPlaceRequest("New Document");
                String folder = ((DocumentListPresenter)((DocumentListViewImpl)DocumentListViewImpl.this).presenter).currentCMSContentSummary == null ? "/" : ((DocumentListPresenter)((DocumentListViewImpl)DocumentListViewImpl.this).presenter).currentCMSContentSummary.getPath();
                req.addParameter("folder", folder);
                DocumentListViewImpl.this.placeManager.goTo((PlaceRequest)req);
            }
        });
        this.filtersButtonGroup = new ButtonGroup(new Button[]{this.parentLink, this.homeLink, this.newLink});
        filtersBar.add((Widget)this.filtersButtonGroup);
        this.listGrid.getCenterToolbar().add((Widget)filtersBar);
    }

    private void initPathLink() {
        FlowPanel container = new FlowPanel();
        Label pathLabel = new Label();
        pathLabel.setText("Path:");
        this.pathLink = new Anchor();
        this.pathLink.setText("/");
        container.add((Widget)pathLabel);
        container.add((Widget)this.pathLink);
        this.listGrid.getLeftToolbar().add((Widget)container);
    }

    @Override
    public void updatePathLink() {
        if (((DocumentListPresenter)this.presenter).currentCMSContentSummary != null) {
            String path = ((DocumentListPresenter)this.presenter).currentCMSContentSummary.getPath();
            if (path != null && !path.equals("")) {
                this.pathLink.setText(path);
            } else {
                this.pathLink.setText("/");
            }
        } else {
            this.pathLink.setText("/");
        }
    }

    protected class GoHasCell
    implements HasCell<CMSContentSummary, CMSContentSummary> {
        private ActionCell<CMSContentSummary> cell;

        public GoHasCell(String text, ActionCell.Delegate<CMSContentSummary> delegate) {
            this.cell = new ActionCell<CMSContentSummary>(text, delegate){

                public void render(Cell.Context context, CMSContentSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DocumentListViewImpl.this.constants.Go() + "'>" + DocumentListViewImpl.this.constants.Go() + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<CMSContentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<CMSContentSummary, CMSContentSummary> getFieldUpdater() {
            return null;
        }

        public CMSContentSummary getValue(CMSContentSummary object) {
            return object;
        }
    }

    protected class RemoveHasCell
    implements HasCell<CMSContentSummary, CMSContentSummary> {
        private ActionCell<CMSContentSummary> cell;

        public RemoveHasCell(String text, ActionCell.Delegate<CMSContentSummary> delegate) {
            this.cell = new ActionCell<CMSContentSummary>(text, delegate){

                public void render(Cell.Context context, CMSContentSummary value, SafeHtmlBuilder sb) {
                    SafeHtmlBuilder mysb = new SafeHtmlBuilder();
                    mysb.appendHtmlConstant("<a href='javascript:;' class='btn btn-mini' style='margin-right:5px;' title='" + DocumentListViewImpl.this.constants.Remove() + "'>" + DocumentListViewImpl.this.constants.Remove() + "</a>");
                    sb.append(mysb.toSafeHtml());
                }
            };
        }

        public Cell<CMSContentSummary> getCell() {
            return this.cell;
        }

        public FieldUpdater<CMSContentSummary, CMSContentSummary> getFieldUpdater() {
            return null;
        }

        public CMSContentSummary getValue(CMSContentSummary object) {
            return object;
        }
    }

    static interface Binder
    extends UiBinder<Widget, DocumentListViewImpl> {
    }
}

