/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.console.ng.es.backend.server.RequestSummaryHelper;
import org.jbpm.console.ng.es.model.ErrorSummary;
import org.jbpm.console.ng.es.model.RequestDetails;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.executor.api.CommandContext;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.entities.STATUS;

@Service
@ApplicationScoped
@Transactional
public class ExecutorServiceEntryPointImpl
implements ExecutorServiceEntryPoint {
    @Inject
    org.jbpm.executor.ExecutorServiceEntryPoint executor;

    public List<RequestSummary> getQueuedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getQueuedRequests());
    }

    public List<RequestSummary> getCompletedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getCompletedRequests());
    }

    public List<RequestSummary> getInErrorRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getInErrorRequests());
    }

    public List<RequestSummary> getCancelledRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getCancelledRequests());
    }

    public List<ErrorSummary> getAllErrors() {
        return RequestSummaryHelper.adaptErrorList(this.executor.getAllErrors());
    }

    public List<RequestSummary> getAllRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getAllRequests());
    }

    public List<RequestSummary> getRequestsByStatus(List<String> statuses) {
        List<STATUS> statusList = RequestSummaryHelper.adaptStatusList(statuses);
        return RequestSummaryHelper.adaptRequestList(this.executor.getRequestsByStatus(statusList));
    }

    public RequestDetails getRequestDetails(Long requestId) {
        RequestInfo request = this.executor.getRequestById(requestId);
        RequestSummary summary = RequestSummaryHelper.adaptRequest(request);
        List<ErrorSummary> errors = RequestSummaryHelper.adaptErrorList(request.getErrorInfo());
        List<RequestParameterSummary> params = RequestSummaryHelper.adaptInternalMap(request);
        return new RequestDetails(summary, errors, params);
    }

    public int clearAllRequests() {
        return this.executor.clearAllRequests();
    }

    public int clearAllErrors() {
        return this.executor.clearAllErrors();
    }

    public Long scheduleRequest(String commandName, Map<String, String> ctx) {
        CommandContext commandContext = null;
        if (ctx != null && !ctx.isEmpty()) {
            commandContext = new CommandContext(new HashMap<String, String>(ctx));
        }
        return this.executor.scheduleRequest(commandName, commandContext);
    }

    public Long scheduleRequest(String commandName, Date date, Map<String, String> ctx) {
        CommandContext commandContext = null;
        if (ctx != null && !ctx.isEmpty()) {
            commandContext = new CommandContext(new HashMap<String, String>(ctx));
        }
        return this.executor.scheduleRequest(commandName, date, commandContext);
    }

    public void cancelRequest(Long requestId) {
        this.executor.cancelRequest(requestId);
    }

    public void init() {
        this.executor.init();
    }

    public void destroy() {
        this.executor.destroy();
    }

    public Boolean isActive() {
        return this.executor.isActive();
    }

    public Boolean startStopService(int waitTime, int nroOfThreads) {
        this.executor.setInterval(waitTime);
        this.executor.setThreadPoolSize(nroOfThreads);
        if (this.executor.isActive()) {
            this.executor.destroy();
        } else {
            this.executor.init();
        }
        return this.executor.isActive();
    }

    public int getInterval() {
        return this.executor.getInterval();
    }

    public void setInterval(int waitTime) {
        this.executor.setInterval(waitTime);
    }

    public int getRetries() {
        return this.executor.getRetries();
    }

    public void setRetries(int defaultNroOfRetries) {
        this.executor.setRetries(defaultNroOfRetries);
    }

    public int getThreadPoolSize() {
        return this.executor.getThreadPoolSize();
    }

    public void setThreadPoolSize(int nroOfThreads) {
        this.executor.setThreadPoolSize(nroOfThreads);
    }

    public List<RequestSummary> getPendingRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getPendingRequests());
    }

    public List<RequestSummary> getPendingRequestById(Long id) {
        return RequestSummaryHelper.adaptRequestList(this.executor.getPendingRequestById(id));
    }

    public List<RequestSummary> getRunningRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getRunningRequests());
    }

    public List<RequestSummary> getFutureQueuedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getFutureQueuedRequests());
    }
}

