/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.es.model.ErrorSummary;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;

public class RequestSummaryHelper {
    public static List<RequestSummary> adaptRequestList(List<RequestInfo> requests) {
        ArrayList<RequestSummary> requestSummaries = new ArrayList<RequestSummary>(requests.size());
        for (RequestInfo request : requests) {
            requestSummaries.add(RequestSummaryHelper.adaptRequest(request));
        }
        return requestSummaries;
    }

    public static RequestSummary adaptRequest(RequestInfo request) {
        return new RequestSummary(request.getId(), request.getTime(), request.getStatus().name(), request.getCommandName(), request.getMessage(), request.getKey());
    }

    public static List<ErrorSummary> adaptErrorList(List<? extends ErrorInfo> errors) {
        ArrayList<ErrorSummary> errorSummaries = new ArrayList<ErrorSummary>(errors.size());
        for (ErrorInfo errorInfo : errors) {
            errorSummaries.add(new ErrorSummary(errorInfo.getId(), errorInfo.getTime(), errorInfo.getMessage(), errorInfo.getStacktrace(), ((org.jbpm.executor.entities.ErrorInfo)errorInfo).getRequestInfo().getId()));
        }
        return errorSummaries;
    }

    public static List<STATUS> adaptStatusList(List<String> statuses) {
        ArrayList<STATUS> statusList = new ArrayList<STATUS>(statuses.size());
        for (String status : statuses) {
            statusList.add(STATUS.valueOf((String)status));
        }
        return statusList;
    }

    public static List<RequestParameterSummary> adaptInternalMap(RequestInfo request) {
        ByteArrayInputStream bain = new ByteArrayInputStream(request.getRequestData());
        ArrayList<RequestParameterSummary> retval = new ArrayList<RequestParameterSummary>();
        try {
            ObjectInputStream oin = new ObjectInputStream(bain);
            CommandContext ctx = (CommandContext)oin.readObject();
            Map map = ctx.getData();
            for (Map.Entry entry : map.entrySet()) {
                retval.add(new RequestParameterSummary((String)entry.getKey(), String.valueOf(entry.getValue())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }
}

