/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.console.ng.es.backend.server.RequestSummaryHelper;
import org.jbpm.console.ng.es.model.ErrorSummary;
import org.jbpm.console.ng.es.model.RequestDetails;
import org.jbpm.console.ng.es.model.RequestKey;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.jbpm.console.ng.es.service.ExecutorServiceEntryPoint;
import org.jbpm.console.ng.ga.model.QueryFilter;
import org.jbpm.console.ng.ga.service.GenericServiceEntryPoint;
import org.jbpm.executor.RequeueAware;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class ExecutorServiceEntryPointImpl
implements ExecutorServiceEntryPoint,
GenericServiceEntryPoint<RequestKey, RequestSummary> {
    private boolean executorDisabled = "true".equalsIgnoreCase(System.getProperty("org.kie.executor.disabled"));
    @Inject
    ExecutorService executor;

    public List<RequestSummary> getQueuedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getCompletedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getCompletedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getInErrorRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getInErrorRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getCancelledRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getCancelledRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<ErrorSummary> getAllErrors() {
        return RequestSummaryHelper.adaptErrorList(this.executor.getAllErrors(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getAllRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getAllRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getRequestsByStatus(List<String> statuses) {
        List<STATUS> statusList = RequestSummaryHelper.adaptStatusList(statuses);
        return RequestSummaryHelper.adaptRequestList(this.executor.getRequestsByStatus(statusList, new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public RequestDetails getRequestDetails(Long requestId) {
        RequestInfo request = this.executor.getRequestById(requestId);
        RequestSummary summary = RequestSummaryHelper.adaptRequest(request);
        List<ErrorSummary> errors = RequestSummaryHelper.adaptErrorList(request.getErrorInfo());
        List<RequestParameterSummary> params = RequestSummaryHelper.adaptInternalMap(request);
        return new RequestDetails(summary, errors, params);
    }

    public int clearAllRequests() {
        return this.executor.clearAllRequests();
    }

    public int clearAllErrors() {
        return this.executor.clearAllErrors();
    }

    public Long scheduleRequest(String commandName, Map<String, String> ctx) {
        if (!this.validate(commandName)) {
            throw new IllegalArgumentException("Unknown job type given " + commandName);
        }
        CommandContext commandContext = null;
        if (ctx != null && !ctx.isEmpty()) {
            commandContext = new CommandContext(new HashMap<String, String>(ctx));
        }
        return this.executor.scheduleRequest(commandName, commandContext);
    }

    public Long scheduleRequest(String commandName, Date date, Map<String, String> ctx) {
        if (!this.validate(commandName)) {
            throw new IllegalArgumentException("Unknown job type given " + commandName);
        }
        CommandContext commandContext = null;
        if (ctx != null && !ctx.isEmpty()) {
            commandContext = new CommandContext(new HashMap<String, String>(ctx));
        }
        return this.executor.scheduleRequest(commandName, date, commandContext);
    }

    public void cancelRequest(Long requestId) {
        this.executor.cancelRequest(requestId);
    }

    public void requeueRequest(Long requestId) {
        ((RequeueAware)this.executor).requeueById(requestId);
    }

    public void init() {
        this.executor.init();
    }

    public void destroy() {
        this.executor.destroy();
    }

    public Boolean isActive() {
        return this.executor.isActive();
    }

    public Boolean startStopService(int waitTime, int nroOfThreads) {
        this.setInterval(waitTime);
        this.setThreadPoolSize(nroOfThreads);
        if (this.executor.isActive()) {
            this.executor.destroy();
        } else {
            this.executor.init();
        }
        return this.executor.isActive();
    }

    public int getInterval() {
        Long interval = TimeUnit.SECONDS.convert(this.executor.getInterval(), this.executor.getTimeunit());
        return interval.intValue();
    }

    public void setInterval(int waitTime) {
        Long interval = this.executor.getTimeunit().convert(waitTime, TimeUnit.SECONDS);
        this.executor.setInterval(interval.intValue());
    }

    public int getRetries() {
        return this.executor.getRetries();
    }

    public void setRetries(int defaultNroOfRetries) {
        this.executor.setRetries(defaultNroOfRetries);
    }

    public int getThreadPoolSize() {
        return this.executor.getThreadPoolSize();
    }

    public void setThreadPoolSize(int nroOfThreads) {
        this.executor.setThreadPoolSize(nroOfThreads);
    }

    public List<RequestSummary> getPendingRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getPendingRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getPendingRequestById(Long id) {
        return RequestSummaryHelper.adaptRequestList(this.executor.getPendingRequestById(id));
    }

    public List<RequestSummary> getRunningRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getRunningRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public List<RequestSummary> getFutureQueuedRequests() {
        return RequestSummaryHelper.adaptRequestList(this.executor.getFutureQueuedRequests(new QueryContext(Integer.valueOf(0), Integer.valueOf(100))));
    }

    public PageResponse<RequestSummary> getData(QueryFilter filter) {
        PageResponse response = new PageResponse();
        List<RequestSummary> requestSummarys = this.getRequests(filter);
        response.setStartRowIndex(filter.getOffset().intValue());
        response.setTotalRowSize(requestSummarys.size() - 1);
        if (requestSummarys.size() > filter.getCount()) {
            response.setTotalRowSizeExact(false);
        } else {
            response.setTotalRowSizeExact(true);
        }
        if (!requestSummarys.isEmpty() && requestSummarys.size() > filter.getCount() + filter.getOffset()) {
            response.setPageRowList(new ArrayList<RequestSummary>(requestSummarys.subList(filter.getOffset(), filter.getOffset() + filter.getCount())));
            response.setLastPage(false);
        } else {
            response.setPageRowList(new ArrayList<RequestSummary>(requestSummarys));
            response.setLastPage(true);
        }
        return response;
    }

    private List<RequestSummary> getRequests(QueryFilter filter) {
        List states = null;
        if (filter.getParams() != null) {
            states = (List)filter.getParams().get("states");
        }
        QueryContext qf = new QueryContext(filter.getOffset(), Integer.valueOf(filter.getCount() + 1), filter.getOrderBy(), filter.isAscending().booleanValue());
        List requestInfoList = null;
        if (states == null || states.isEmpty()) {
            requestInfoList = this.executor.getAllRequests(qf);
        } else {
            List<STATUS> statusList = RequestSummaryHelper.adaptStatusList(states);
            requestInfoList = this.executor.getRequestsByStatus(statusList, qf);
        }
        ArrayList<RequestSummary> requestSummarys = new ArrayList<RequestSummary>(requestInfoList.size());
        for (RequestInfo requestInfo : requestInfoList) {
            if (filter.getParams().get("textSearch") == null || ((String)filter.getParams().get("textSearch")).isEmpty()) {
                requestSummarys.add(RequestSummaryHelper.adaptRequest(requestInfo));
                continue;
            }
            if (!requestInfo.getCommandName().toLowerCase().contains((String)filter.getParams().get("textSearch"))) continue;
            requestSummarys.add(RequestSummaryHelper.adaptRequest(requestInfo));
        }
        return requestSummarys;
    }

    public RequestSummary getItem(RequestKey key) {
        return null;
    }

    protected boolean validate(String command) {
        try {
            Class.forName(command);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isExecutorDisabled() {
        return this.executorDisabled;
    }

    public List<RequestSummary> getAll(QueryFilter filter) {
        return this.getRequests(filter);
    }
}

