/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.console.ng.es.model.ErrorSummary;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.server.api.model.instance.ErrorInfoInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummaryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSummaryHelper.class);

    public static List<RequestSummary> adaptRequestList(List<RequestInfo> requests) {
        ArrayList<RequestSummary> requestSummaries = new ArrayList<RequestSummary>(requests.size());
        for (RequestInfo request : requests) {
            requestSummaries.add(RequestSummaryHelper.adaptRequest(request));
        }
        return requestSummaries;
    }

    public static RequestSummary adaptRequest(RequestInfo request) {
        return new RequestSummary(request.getId(), request.getTime(), request.getStatus().name(), request.getCommandName(), request.getMessage(), request.getKey());
    }

    public static List<RequestSummary> adaptRequestInstanceList(List<RequestInfoInstance> requests) {
        ArrayList<RequestSummary> requestSummaries = new ArrayList<RequestSummary>(requests.size());
        for (RequestInfoInstance request : requests) {
            requestSummaries.add(RequestSummaryHelper.adaptRequest(request));
        }
        return requestSummaries;
    }

    public static RequestSummary adaptRequest(RequestInfoInstance request) {
        return new RequestSummary(request.getId(), request.getScheduledDate(), request.getStatus(), request.getCommandName(), request.getMessage(), request.getBusinessKey());
    }

    public static List<ErrorSummary> adaptErrorList(List<? extends ErrorInfo> errors) {
        ArrayList<ErrorSummary> errorSummaries = new ArrayList<ErrorSummary>(errors.size());
        for (ErrorInfo errorInfo : errors) {
            errorSummaries.add(new ErrorSummary(errorInfo.getId(), errorInfo.getTime(), errorInfo.getMessage(), errorInfo.getStacktrace(), null));
        }
        return errorSummaries;
    }

    public static List<ErrorSummary> adaptErrorInstanceList(List<ErrorInfoInstance> errors) {
        ArrayList<ErrorSummary> errorSummaries = new ArrayList<ErrorSummary>(errors.size());
        for (ErrorInfoInstance error : errors) {
            errorSummaries.add(new ErrorSummary(error.getId(), error.getErrorDate(), error.getMessage(), error.getStacktrace(), null));
        }
        return errorSummaries;
    }

    public static List<STATUS> adaptStatusList(List<String> statuses) {
        ArrayList<STATUS> statusList = new ArrayList<STATUS>(statuses.size());
        for (String status : statuses) {
            statusList.add(STATUS.valueOf((String)status));
        }
        return statusList;
    }

    public static List<RequestParameterSummary> adaptInternalMap(RequestInfoInstance request) {
        ArrayList<RequestParameterSummary> retval = new ArrayList<RequestParameterSummary>();
        try {
            Map map = request.getData();
            for (Map.Entry entry : map.entrySet()) {
                retval.add(new RequestParameterSummary((String)entry.getKey(), String.valueOf(entry.getValue())));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading request data", (Throwable)e);
        }
        return retval;
    }
}

