/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.es.backend.server;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.console.ng.es.backend.server.ErrorSummaryMapper;
import org.jbpm.console.ng.es.backend.server.RequestSummaryMapper;
import org.jbpm.console.ng.es.model.RequestDetails;
import org.jbpm.console.ng.es.model.RequestParameterSummary;
import org.jbpm.console.ng.es.model.RequestSummary;
import org.kie.server.api.model.instance.RequestInfoInstance;

public class RequestDetailsMapper
implements Function<RequestInfoInstance, RequestDetails> {
    @Override
    public RequestDetails apply(RequestInfoInstance requestInfoInstance) {
        Optional<RequestInfoInstance> request = Optional.ofNullable(requestInfoInstance);
        if (!request.isPresent()) {
            return null;
        }
        RequestSummary summary = request.map(new RequestSummaryMapper()).get();
        List errors = request.map(r -> r.getErrors()).map(e -> e.getItems()).orElse(Collections.emptyList()).stream().map(new ErrorSummaryMapper()).collect(Collectors.toList());
        List params = request.map(r -> r.getData()).orElse(Collections.emptyMap()).entrySet().stream().map(e -> new RequestParameterSummary((String)e.getKey(), String.valueOf(e.getValue()))).collect(Collectors.toList());
        return new RequestDetails(summary, errors, params);
    }
}

